import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0)

np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data
age_groups = [20, 25, 30, 35, 40, 50, 65]
yoga = [60, 65, 62, 70, 68, 75, 72]
running = [70, 72, 78, 80, 75, 85, 82]
cycling = [65, 68, 73, 70, 77, 75, 80]
swimming = [75, 70, 85, 80, 82, 87, 90]

# Labels and Plot Types
label_yoga = "Yoga"
label_running = "Running"
label_cycling = "Cycling"
label_swimming = "Swimming"

# Axes Limits and Labels
xlim_values = [20, 65]
ylim_values = [50, 100]
xlabel_value = "Age"
ylabel_value = "Heart Health Score"
xticks_values = np.arange(20, 66, 10)
yticks_values = np.arange(50, 101, 10)


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(8, 6))  # Adjusting figure size to match original image dimensions
plt.plot(
    age_groups,
    yoga,
    "-o",
    label=label_yoga,
    color="#1f77b4",
    clip_on=False,
    zorder=10,
)
plt.plot(
    age_groups,
    running,
    "-^",
    label=label_running,
    color="#ff7f0e",
    clip_on=False,
    zorder=10,
)
plt.plot(
    age_groups,
    cycling,
    "-x",
    label=label_cycling,
    color="#2ca02c",
    clip_on=False,
    zorder=10,
)
plt.plot(
    age_groups,
    swimming,
    "-x",
    label=label_swimming,
    color="#d62728",
    clip_on=False,
    zorder=10,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding grid, legend, and labels
plt.grid(True)
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.08), ncol=4, frameon=False)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_1.pdf", bbox_inches="tight")
