
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data
investment_amount = ["0", "1000", "5000", "10000", "20000", "50000", "100000", "200000"]
stock_investment = [1, 2.5, 4, 6, 5, 3.5, 2.5, 1]  
bond_investment = [4, 3.8, 3.5, 3, 2.5, 1.8, 1, 0.5]  
real_estate_investment = [0, 1.5, 3, 2.5, 4, 5.5, 6, 5.8]  

# Positions for the bars on the x-axis
ind = np.arange(len(investment_amount))

# Labels and Legend
xlabel = "Investment Amount ($)"
ylabel = "Performance Gain (%)"
stock_investment_label = "Stock Investment"
bond_investment_label = "Bond Investment"
real_estate_investment_label = "Real Estate Investment"

# Limits
xlim = (investment_amount[0], investment_amount[-1])
ylim = (0, 7)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 6))  # Adjust the size to match the original image's dimensions
ax.plot(investment_amount, stock_investment, label=stock_investment_label, color="#0173b2")
ax.plot(investment_amount, bond_investment, label=bond_investment_label, color="#de8f05")
ax.plot(investment_amount, real_estate_investment, label=real_estate_investment_label, color="#20a983")

# Setting the x-axis and y-axis limits
ax.set_ylim(*ylim)  # Set y-axis to go from 0 to 7
ax.set_xlim(*xlim)  # Set x-axis limits to cover the range of n_aug without extra space

# Labels and Title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)

# Legend
ax.legend(loc="upper center", fontsize=14, frameon=False, ncol=3, bbox_to_anchor=(0.5, 1.1))

# Grid
ax.grid(True, ls="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig('line_10.pdf', bbox_inches='tight')
