import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Sample data points
engine_load = [0, 20, 40, 60, 80]
sedan_mpg = [30, 28, 26, 24, 22]
suv_mpg = [25, 23, 21, 19, 17]
truck_mpg = [20, 18, 16, 14, None]
minivan_mpg = [22, 20, 18, 16, None]
baseline_mpg = [30, 30]
baseline_load = [-10, 90]

# Axes Limits and Labels
xlabel_value = "Engine Load (%)"
xlim_values = [-10, 90]

ylabel_value = "Fuel Efficiency (MPG)"
ylim_values = [10, 32]
yticks_values = [15, 20, 25, 30]

# Labels
label_1 = "Sedan"
label_2 = "SUV"
label_3 = "Truck"
label_4 = "Minivan"
label_5 = "Baseline"

# Titles
title_1 = "Effect of Engine Load on Fuel Efficiency"
title_2 = "Vehicle Types"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(6, 6))  # Adjust figure size to match original image dimensions
plt.plot(engine_load, sedan_mpg, label=label_1, color="red", marker="o")
plt.plot(engine_load, suv_mpg, label=label_2, color="green", marker="o")
plt.plot(engine_load, truck_mpg, label=label_3, color="blue", marker="o")
plt.plot(engine_load, minivan_mpg, label=label_4, color="orange", marker="o")
plt.plot(baseline_load, baseline_mpg, label=label_5, color="black", linestyle="--")

# Add title and labels
plt.title(title_1)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xticks(engine_load)
plt.xlim(xlim_values)
plt.yticks(yticks_values)
plt.ylim(ylim_values)
# Add legend with additional entry
plt.legend(title=title_2,loc="lower right")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('line_11.pdf', bbox_inches='tight')
