
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
dosage_levels = [0.2, 0.4,0.6, 0.8, 1.00]
std_side_effects_young = [0.7, 0.5, 0.3, 0.6, 0.8]
std_side_effects_adult = [0.6, 0.45, 0.4, 0.35,0.5]
std_side_effects_elderly = [0.2, 0.35, 0.25, 0.5,0.37]

# Extracted variables
line_label_young = "Young Patients"
line_label_adult = "Adult Patients"
line_label_elderly = "Elderly Patients"
xlim_values = (0.25, 1.00)
ylim_values = (0.00, 0.8)
xlabel_value = "Dosage Levels (mg)"
ylabel_value = "Std of Side Effects"
xticks_values = dosage_levels


xtickslabel_fontsize = 14
ytickslabel_fontsize = 14

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines with increased marker size and line width
plt.figure(figsize=(8, 6))
plt.plot(
    dosage_levels,
    std_side_effects_young,
    marker="*",
    markersize=10,
    linewidth=2,
    color="#2ab34a",
    label=line_label_young,
    clip_on=False,
    zorder=10,
)
plt.plot(
    dosage_levels,
    std_side_effects_adult,
    marker="^",
    markerfacecolor="white",
    markersize=10,
    linewidth=2,
    markeredgecolor="#ee756e",
    color="#ee756e",
    clip_on=False,
    zorder=10,
    label=line_label_adult,
)
plt.plot(
    dosage_levels,
    std_side_effects_elderly,
    marker="o",
    markerfacecolor="white",
    markersize=10,
    linewidth=2,
    markeredgecolor="#4995c6",
    color="#4995c6",
    clip_on=False,
    zorder=10,
    label=line_label_elderly,
)

# Setting the x-axis and y-axis limits
plt.ylim(*ylim_values)  # Set y-axis to go from 0 to 7
plt.yticks(fontsize=ytickslabel_fontsize)
plt.xlim(*xlim_values)  # Set y-axis to go from 0 to 7
# Set x-axis to show only the values in the sample_ratio list
plt.xticks(xticks_values, fontsize=xtickslabel_fontsize)

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=18)
plt.ylabel(ylabel_value, fontsize=18)

# Adding legend with increased font size
plt.legend(
    fontsize="large",
    loc="upper center",
    ncol=3,
    frameon=False,
    bbox_to_anchor=(0.5, 1.1),
)

# Adding grid
plt.grid(True, alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig('line_12.pdf', bbox_inches='tight')
