import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
# Sample data to mimic the trends in the provided image
years = np.arange(1, 21)
sedan = np.array([26.76, 25.93, 27.03, 28.82, 28.97, 26.65, 29.11, 28.53, 29.11, 30.15, 30.41, 32.24, 32.08, 31.96, 32.81, 33.23, 34.92, 33.74, 34.79, 34.15])
suv = np.array([21.76, 20.93, 22.03, 23.82, 23.97, 21.65, 24.11, 23.53, 24.11, 25.15, 25.41, 27.24, 27.08, 26.96, 27.81, 28.23, 29.92, 28.74, 29.79, 29.15])
truck = np.array([16.76, 15.93, 17.03, 18.82, 18.97, 16.65, 19.11, 18.53, 19.11, 20.15, 20.41, 22.24, 22.08, 21.96, 22.81, 23.23, 24.92, 23.74, 24.79, 24.15])
minivan = np.array([19.76, 18.93, 20.03, 21.82, 21.97, 19.65, 22.11, 21.53, 22.11, 23.15, 23.41, 25.24, 25.08, 24.96, 25.81, 26.23, 27.92, 26.74, 27.79, 27.15])

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [0, 21]
xticks_values = np.arange(1, 22, 1)

ylabel_value = "Fuel Efficiency (MPG)"
ylim_values = [10, 40]
yticks_values = np.arange(10, 41, 5)

# Labels
label_Sedan = "Sedan"
label_SUV = "SUV"
label_Truck = "Truck"
label_Minivan = "Minivan"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(8, 6))
plt.plot(
    years,
    sedan,
    marker="s",
    markersize=7,
    color="#393b79",
    mfc="w",
    mew=2,
    label=label_Sedan,
    linewidth=2,
)
plt.plot(
    years,
    suv,
    marker="v",
    markersize=7,
    color="#e7969c",
    mfc="w",
    mew=2,
    label=label_SUV,
    linewidth=2,
)
plt.plot(
    years,
    truck,
    marker="D",
    markersize=7,
    color="#a55194",
    mfc="w",
    mew=2,
    label=label_Truck,
    linewidth=2,
)
plt.plot(
    years,
    minivan,
    marker="o",
    markersize=4,
    color="#de9ed6",
    mfc="w",
    mew=2,
    label=label_Minivan,
    linewidth=2,
)  # Adjusted color for Minivan

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Setting x-axis ticks
plt.xticks(xticks_values)  # Ticks from 2000 to 2020, interval of 1
plt.xlim(xlim_values)  # Slightly beyond 2000 and 2019 for a margin

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Adding legend with a different style and position
plt.legend(frameon=True, fontsize=11, loc="upper right")

# Adding gridlines
plt.grid(True, linestyle="-", linewidth=0.5, axis="y", alpha=1)

# Adjusting tick label size
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig('line_15.pdf', bbox_inches='tight')
