import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data
iterations = np.array([0, 250, 500, 750, 1000, 1250, 1500, 1750, 2000])
sedan = np.array([20, 22, 24, 25, 26, 27, 28, 28.5, 29])
sedan_ft = np.array([18, 19, 21, 22, 23, 24, 25, 25.5, 26])
suv = np.array([15, 17, 18, 19, 20, 21, 21.5, 22, 22.5])
suv_ft = np.array([14, 15, 16, 17, 18, 19, 20, 20.5, 21])

# Axes Limits and Labels
xlabel_value = "Iterations"
ylabel_value = "Fuel Efficiency (MPG)"

# Labels
label_1 = "Standard"
label_2 = "Fine-tuned"

# Titles
title_1 = "Sedan Fuel Efficiency Improvement"
title_2 = "SUV Fuel Efficiency Improvement"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(9, 4))

# First subplot
plt.subplot(1, 2, 1)
plt.plot(
    iterations,
    sedan,
    marker="o",
    color="#0a6ae1",
    label=label_1,
    markerfacecolor="#0a6ae1",
    linewidth=2,
    markersize=5,
)
plt.plot(
    iterations,
    sedan_ft,
    marker="o",
    color="#d75faa",
    label=label_2,
    markerfacecolor="#d75faa",
    linewidth=2,
    markersize=5,
)
plt.fill_between(iterations, sedan - 1, sedan + 1, color="#0a6ae1", alpha=0.2)
plt.fill_between(
    iterations, sedan_ft - 0.8, sedan_ft + 0.8, color="#d75faa", alpha=0.2
)
plt.title(title_1, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)

# Second subplot
plt.subplot(1, 2, 2)
plt.plot(
    iterations,
    suv,
    marker="o",
    color="#0a6ae1",
    label=label_1,
    markerfacecolor="#0a6ae1",
    linewidth=2,
    markersize=5,
)
plt.plot(
    iterations,
    suv_ft,
    marker="o",
    color="#d75faa",
    label=label_2,
    markerfacecolor="#d75faa",
    linewidth=2,
    markersize=5,
)
plt.fill_between(
    iterations, suv - 1, suv + 1, color="#0a6ae1", alpha=0.2
)
plt.fill_between(
    iterations, suv_ft - 0.8, suv_ft + 0.8, color="#d75faa", alpha=0.2
)
plt.title(title_2, fontsize=14)
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.legend(loc="lower right", frameon=True, bbox_to_anchor=(1, 0.1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('line_18.pdf', bbox_inches='tight')
