import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
fraction_of_evs = np.array([0.01, 0.1, 1])
fleet1_emissions = np.array([200, 150, 100])
fleet2_emissions = np.array([220, 170, 120])
fleet3_emissions = np.array([240, 190, 140])

# Axes Limits and Labels
xlabel_value = "Fraction of EVs in Fleet (log scale)"
xlim_values = [0.01, 1]

ylabel_value = "CO2 Emissions (g/km)"
ylim_values = [90, 250]
yticks_values = np.arange(100, 251, 50)

# Labels
label_Fleet1 = "Fleet 1"
label_Fleet2 = "Fleet 2"
label_Fleet3 = "Fleet 3"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(figsize=(5, 4))  # Adjusting figure size to match original image dimensions
plt.plot(fraction_of_evs, fleet1_emissions, "o-", color="green", label=label_Fleet1)
plt.plot(fraction_of_evs, fleet2_emissions, "o-", color="red", label=label_Fleet2)
plt.plot(fraction_of_evs, fleet3_emissions, "o-", color="blue", label=label_Fleet3)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=16)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Set x-axis fontsize
plt.xticks(fontsize=16)

# Setting the x-axis to log scale
plt.xscale("log")

# Adding labels and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Adding grid
plt.grid(True, which="both", ls="-", linewidth=0.8)

# Adding legend, show it horizontally and place it at the lower right corner
plt.legend(loc="upper right", fontsize=12, ncol=3, columnspacing=0.5, edgecolor="black")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig('line_19.pdf', bbox_inches='tight')
