import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
years = [2015, 2016, 2017, 2018, 2019]  # 5 years of data
ev_sedans = [15000, 30000, 50000, 70000, 100000]  # Number of electric sedans registered
ev_suvs = [5000, 15000, 25000, 45000, 70000]  # Number of electric SUVs registered
ev_trucks = [2000, 8000, 15000, 25000, 40000]  # Number of electric trucks registered

# Simulating standard deviations for error
ev_sedans_std = np.array([2744.07, 3575.95, 3013.82, 2724.42, 2118.27])
ev_suvs_std = np.array([3229.47, 2187.94, 4458.87, 4818.31, 1917.21])
ev_trucks_std = np.array([3958.63, 2644.47, 2840.22, 4627.98, 355.18])

# Labels
label_ev_sedans = "Electric Sedans"
label_ev_suvs = "Electric SUVs"
label_ev_trucks = "Electric Trucks"

# Axes Limits and Labels
xlabel_value = "Years"
yticks_values = np.arange(0, 110000, 20000)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines with error bands
plt.figure(figsize=(4, 3))
plt.plot(years, ev_sedans, "o-", color="orange", label=label_ev_sedans)
plt.fill_between(
    years,
    ev_sedans - ev_sedans_std,
    ev_sedans + ev_sedans_std,
    color="orange",
    alpha=0.2,
)

plt.plot(years, ev_suvs, "o-", color="blue", label=label_ev_suvs)
plt.fill_between(
    years,
    ev_suvs - ev_suvs_std,
    ev_suvs + ev_suvs_std,
    color="blue",
    alpha=0.2,
)

plt.plot(years, ev_trucks, "o-", color="green", label=label_ev_trucks)
plt.fill_between(
    years,
    ev_trucks - ev_trucks_std,
    ev_trucks + ev_trucks_std,
    color="green",
    alpha=0.2,
)

# x labels
plt.xlabel(xlabel_value)
plt.xticks(years)
plt.yticks(yticks_values)

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["left"].set_position(("outward", 10))  # move left y-axis outwards
ax.spines["bottom"].set_position(("outward", 10))  # move bottom x-axis outwards
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(
    True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5
)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig('line_2.pdf', bbox_inches='tight')
