import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
x = [40, 50, 60, 70, 80, 90, 100]
y = [15.0, 14.5, 14.0, 13.5, 13.0, 12.5, 12.0]
bits = [
    "15.0 km/l",
    "14.5 km/l",
    "14.0 km/l",
    "13.5 km/l",
    "13.0 km/l",
    "12.5 km/l",
    "12.0 km/l",
]

# Axes Limits and Labels
xlabel_value = "Speed (km/h)"
xlim_values = [35, 105]
xticks_values = np.arange(40, 101, 10)

ylabel_value = "Fuel Efficiency (km/l)"
ylim_values = [10.0, 22.5]
yticks_values = np.arange(10.0, 23.0, 2.5)

# Labels
label_1 = "Test Vehicle"
label_2 = "Sedan Avg: 18.0 km/l"
label_3 = "SUV Avg: 14.0 km/l"
label_4 = "Truck Avg: 12.0 km/l"
label_5 = "Motorbike Avg: 20.0 km/l"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(5, 4))

# Plot the line
ax.plot(x, y, marker="o", color="blue", label=label_1)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=10)
plt.xticks(xticks_values, fontsize=10)
plt.xlim(xlim_values)

# Annotate the points with bit values
for i, txt in enumerate(bits):
    ax.annotate(
        txt, (x[i], y[i]), textcoords="offset points", xytext=(0, 10), ha="center"
    )

# Horizontal lines for comparison
ax.axhline(y=18.0, color="magenta", linestyle="--", label=label_2)
ax.axhline(y=14.0, color="orange", linestyle="--", label=label_3)
ax.axhline(y=12.0, color="green", linestyle="--", label=label_4)
ax.axhline(y=20.0, color="red", linestyle="--", label=label_5)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)
ax.set_ylabel(ylabel_value, fontsize=12)

# Set the legend
ax.legend(loc="center right", fontsize=10)

# Set grid
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig('line_22.pdf', bbox_inches='tight')
