import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data
traffic_cycles = np.arange(0, 10, 1)
avg_travel_time = np.array([420, 390, 370, 350, 340, 330, 320, 310, 300, 290])
std_dev_travel_time = np.array([30, 28, 25, 22, 20, 18, 15, 13, 10, 8])

# Axes Limits and Labels
xlabel_value = "Traffic Light Cycles"
ylabel_value = "Average Travel Time (seconds)"
ylim_values = [150, 450]
yticks_values = np.arange(200, 451, 50)

# Labels
label_Average = "Average Travel Time"
label_Standard_Deviation = "Standard Deviation"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the average line
plt.figure(figsize=(6, 4))
plt.plot(traffic_cycles, avg_travel_time, label=label_Average, marker="o", color="#1f77b4")

# Plotting the standard deviation as a shaded area
plt.fill_between(
    traffic_cycles,
    avg_travel_time - std_dev_travel_time,
    avg_travel_time + std_dev_travel_time,
    color="#1f77b4",
    alpha=0.2,
    label=label_Standard_Deviation,
)

# Adjusting y-axis range
plt.ylim(ylim_values)

# Adding yticks
plt.yticks(yticks_values)
plt.ylim(ylim_values)

# Adding labels and title with smaller font size
plt.xlabel(xlabel_value, fontsize=10)
plt.ylabel(ylabel_value, fontsize=10)

# Adding legend with no border
plt.legend(frameon=True, fontsize=10)

# Adding grid
plt.grid(True, color="#d1d1d1")

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to add more space on the right
plt.tight_layout()
plt.savefig('line_24.pdf', bbox_inches='tight')
