import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
optimization_steps = range(1, 21)
model_a_efficiency = [
    20,
    22,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    36,
    36,
    36,
    36,
    36,
]
single_steps = [0, 21]
model_b_efficiency = [20] * len(single_steps)

# Axes Limits and Labels
xlabel_value = "# of Optimization Steps"
xlim_values = [0, 21]
xticks_values = [0, 5, 10, 15, 20]

ylabel_value = "Average Fuel Efficiency (MPG)"
ylim_values = [18, 38]

# Labels
label_1 = "Model A"
label_2 = "Model B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines
plt.figure(figsize=(4, 3))
plt.plot(optimization_steps, model_a_efficiency, "o-.", label=label_1, color="#8280cd")
plt.plot(single_steps, model_b_efficiency, "-", label=label_2, color="red")

# Adding legend
plt.legend(loc = "center right")

# Labeling axes
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.xlim(xlim_values)
plt.xticks(xticks_values)
plt.ylim(ylim_values)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('line_29.pdf', bbox_inches='tight')
