import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for 2010-2015
period1_x = np.array(
    ["All", "Sedan", "SUV", "Truck", "Minivan", "Coupe", "Convertible", "Hatchback"]
)
period1_y = np.array([25, 27, 22, 18, 20, 28, 26, 30])
period1_err = np.array([2, 3, 3, 2, 2, 3, 2, 3])

# Data for 2016-2021
period2_x = np.array(
    ["All", "Sedan", "SUV", "Truck", "Minivan", "Coupe", "Convertible", "Hatchback"]
)
period2_y = np.array([28, 30, 25, 20, 23, 31, 29, 33])
period2_err = np.array([2, 3, 3, 2, 2, 3, 2, 3])
# Labels
label_period1 = "2010-2015"
label_period2 = "2016-2021"

# Axes Limits and Labels
ylabel_value = "Average Fuel Efficiency (MPG)"
yticks_values = np.arange(15, 36, 5)
ylim_values = [15, 35]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the data
plt.figure(
    figsize=(10, 5)
)  # Adjusting figure size to match the original image's dimensions
plt.errorbar(
    period1_x,
    period1_y,
    yerr=period1_err,
    fmt="o-",
    label=label_period1,
    color="#3d89be",
    capsize=5,
)
plt.errorbar(
    period2_x,
    period2_y,
    yerr=period2_err,
    fmt="--",
    label=label_period2,
    color="#ff7f0e",
    marker="s",
    capsize=5,
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=16)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# set x-axis label to be rotated
plt.xticks(rotation=45, fontsize=12)

# Adding labels and title
plt.ylabel(ylabel_value, fontsize=16)
plt.legend(loc="upper center", bbox_to_anchor=(0.72, 1), ncol=2, fontsize=16)

# Adjusting figure size to match the original image's dimensions of 360 (height) by 720 (width)
plt.gcf().set_size_inches(10, 5)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig('line_3.pdf', bbox_inches='tight')
