
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data
age_groups = [22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32]
diet_plan_a = [
    0.0040,
    0.0042,
    0.0041,
    0.0043,
    0.0042,
    0.0043,
    0.0044,
    0.0043,
    0.0044,
    0.0045,
    0.0044,
]
diet_plan_b = [
    0.0032,
    0.0038,
    0.0035,
    0.0036,
    0.0037,
    0.0040,
    0.0037,
    0.0038,
    0.0036,
    0.0032,
    0.0036,
]

# Extracted variables
diet_plan_a_label = "Diet Plan A"
diet_plan_b_label = "Diet Plan B"
xlim_values = [22, 32]
ylim_values = [0.0030, 0.0050]
xlabel_value = "Age Group"
ylabel_value = "Weight Change (kg)"
xticks_values = age_groups
yticks_values = np.arange(0.0030, 0.0051, 0.0005)
xtickslabel_values = [str(age) for age in age_groups]
ytickslabel_values = [str(i) for i in yticks_values]
title_value = "Weight Change Under Different Diet Plans"



legend_location = "lower center"
legend_bbox_to_anchor = (0.5, -0.3)
legend_ncol = 2
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(
    figsize=(6, 4)
)  # Adjusted to match the original image's dimensions

# Plot lines
ax.plot(
    age_groups,
    diet_plan_a,
    marker="o",
    clip_on=False,
    zorder=10,
    color="#1f77b4",
    label=diet_plan_a_label,
    markersize=6,
    mec="white",
)
ax.plot(
    age_groups,
    diet_plan_b,
    marker="o",
    clip_on=False,
    zorder=10,
    color="#ff7f0e",
    label=diet_plan_b_label,
    markersize=6,
    mec="white",
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xlim(xlim_values)

# Title and labels
ax.set_title(title_value)
ax.set_xlabel(xlabel_value)
ax.tick_params(axis="both", which="both", length=0)

# Legend
ax.legend(loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, ncol=legend_ncol, frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig('line_30.pdf', bbox_inches='tight')
