import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Sample data (replace with actual values)
test_samples = [20, 40, 60, 80, 100]
sedan_efficiency = [25, 27, 28, 29, 30]
suv_efficiency = [22, 24, 25, 26, 27]
truck_efficiency = [18, 20, 21, 22, 23]
ev_efficiency = [100, 105, 108, 110, 112]

# Axes Limits and Labels
xlabel_value = "Number of Test Samples"
xlim_values = [5, 105]
xticks_values = np.arange(20, 101, 20)

ylabel_value = "Fuel Efficiency (MPG)"
ylim_values = [15, 115]
yticks_values = np.arange(20, 121, 20)

# Labels
label_sedan = "Sedan"
label_suv = "SUV"
label_truck = "Truck"
label_ev = "Electric Vehicle"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(6, 4))  # Adjusted to match the original image's dimensions
plt.plot(test_samples, sedan_efficiency, marker="v", color="#ffa500", label=label_sedan)
plt.plot(test_samples, suv_efficiency, marker="^", color="#ff4500", label=label_suv)
plt.plot(test_samples, truck_efficiency, marker="s", color="#4169e1", label=label_truck)
plt.plot(test_samples, ev_efficiency, marker="o", color="#00008b", label=label_ev)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, fontsize=10)
plt.xlim(xlim_values)  # Adjusted y-axis limit
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  # Adjusted x-axis limit

# Add vertical dotted line
plt.axvline(x=20, color="blue", linestyle=":", linewidth=1.2)

# Add legend
plt.legend(loc="lower right", fontsize=12)

# Add labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value , fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('line_33.pdf', bbox_inches='tight')
