import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
humidity_level = np.array(
    [10 ** (1), 10 ** (1.2), 10 ** (1.5), 10 ** (1.8), 10 ** (2), 10 ** (2.3)]
)
wind_speed_ratio = np.array([5, 5.5, 6.5, 7, 10, 15])

# Labels and Plot Types
x_humidity_level_10 = 10 ** (1.3)
label_humidity_level_10 = "Humidity Level 10%"
x_humidity_level_20 = 10 ** (1.4)
label_humidity_level_20 = "Humidity Level 20%"
x_humidity_level_50 = 10 ** (1.7)
label_humidity_level_50 = "Humidity Level 50%"
x_humidity_level_80 = 10 ** (1.9)
label_humidity_level_80 = "Humidity Level 80%"
label_empirical_relat_wind = "Empirical Relationship"

# Axes Limits and Labels
yticks_values = np.arange(0, 16, 2)
ylim_values = [0, 16]
xlabel_value = "Humidity Level (%)"
ylabel_value = "Wind Speed (km/h)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(6, 4))

# Add vertical lines
ax.axvline(
    x=x_humidity_level_10, color="#d86810", linestyle="--", label=label_humidity_level_10, linewidth=3
)
ax.axvline(
    x=x_humidity_level_20, color="#029e73", linestyle="--", label=label_humidity_level_20, linewidth=3
)
ax.axvline(
    x=x_humidity_level_50, color="#de8f05", linestyle="--", label=label_humidity_level_50, linewidth=3
)
ax.axvline(
    x=x_humidity_level_80, color="#cc78bc", linestyle="--", label=label_humidity_level_80, linewidth=3
)

# Plot the empirical relationship line
ax.plot(
    humidity_level,
    wind_speed_ratio,
    label=label_empirical_relat_wind,
    color="#0173b2",
    marker="o",
    markersize=8,
    mec="white",
    linewidth=3,
)

# Set yticks
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Customize the plot
ax.set_xscale("log")
ax.set_xlabel(xlabel_value, fontsize=16)
ax.set_ylabel(ylabel_value, fontsize=16)

# Remove x-axis minor ticks
ax.tick_params(axis="x", which="minor", bottom=False)

# Add grid for major ticks only
ax.grid(True, which="major", linestyle="-", linewidth=0.5)

# Add legend
ax.legend(loc="upper left", bbox_to_anchor=(0, 1), fontsize=13)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Adjust layout to not cut off legend
plt.savefig('line_35.pdf', bbox_inches='tight')
