import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data
cargo_units = np.arange(5, 31, 1)
fuel_efficiency_mean = np.array(
    [
        25.2, 24.8, 24.5, 24.2, 23.9, 23.6, 23.4, 23.2, 23.0, 22.8,
        22.7, 22.6, 22.5, 22.4, 22.3, 22.2, 22.1, 22.0, 21.9, 21.8,
        21.7, 21.6, 21.5, 21.4, 21.3, 21.2
    ]
)
fuel_efficiency_std = np.array(
    [
        1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.3, 0.3, 0.3, 0.3, 
        0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 0.3, 
        0.3, 0.3
    ]
)

# Axes Limits and Labels
xlabel_value = "Number of Cargo Units"
xlim_values = [3.5, 32]
xticks_values = np.arange(6, 31, 3)

ylabel_value = "Fuel Efficiency (MPG)"
ylim_values = [20.5, 26.0]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the mean fuel efficiency with the standard deviation as a shaded area
plt.figure(figsize=(6, 5))
plt.plot(cargo_units, fuel_efficiency_mean, color="#1f77b4")
plt.fill_between(
    cargo_units,
    fuel_efficiency_mean - fuel_efficiency_std,
    fuel_efficiency_mean + fuel_efficiency_std,
    color="#1f77b4",
    alpha=0.2,
)

# Set x-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, fontsize=12)
plt.yticks(fontsize=12)
plt.xlim(xlim_values)  # Adjusted x-axis limit
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Labeling the axes
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('line_37.pdf', bbox_inches='tight')
