import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data
test_runs = ["3", "10", "30", "100"]  # Treat test_runs as strings to make them categorical
baseline_efficiency = [30, 30, 30, 30]
model_3 = [28, 27, 26, 29]
model_5 = [27, 29, 24, 25]
model_7 = [26, 27, 25, 27]
model_10 = [23, 24, 23, 22]
model_30 = [20, 23, 28, 21]

# Axes Limits and Labels
xlabel_value = "# Test Runs"
ylabel_value = "Fuel Efficiency (MPG)"
ylim_values = [0.0, 32]
yticks_values = np.arange(0, 31, 5)

# Labels
label_Baseline = "Baseline"
label_3 = "Model 3"
label_5 = "Model 5"
label_7 = "Model 7"
label_10 = "Model 10"
label_30 = "Model 30"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(7, 3))
plt.axhline(y=30, color="black", linestyle="--", linewidth=1, label=label_Baseline)
plt.plot(test_runs, model_3, "r-", marker="s", label=label_3)
plt.plot(test_runs, model_5, "y-", marker="s", label=label_5)
plt.plot(test_runs, model_7, "k-", marker="s", label=label_7)
plt.plot(test_runs, model_10, "b-", marker="s", label=label_10)
plt.plot(test_runs, model_30, "g-", marker="s", label=label_30)

plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)

# Set x-axis labels equidistantly
ax = plt.gca()
ax.set_xticks(np.arange(len(test_runs)))  # Positional indexing for equidistant spacing
ax.set_xticklabels(test_runs, fontsize=14)  # Labeling x-ticks as per test_runs

plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

plt.legend(
    loc="lower left", ncol=3, fontsize=12, columnspacing=5
)  # Adjusted legend settings

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig('line_38.pdf', bbox_inches='tight')
