import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data
years = np.array([2015, 2016, 2017, 2018, 2019])
car_sales = np.array([2.5, 2.8, 3.0, 3.2, 3.6])  # in millions
bike_sales = np.array([1.0, 1.2, 1.1, 1.3, 1.5])  # in millions
bus_sales = np.array([0.8, 0.9, 0.85, 0.9, 1.0])  # in millions
electric_vehicle_sales = np.poly1d(np.polyfit(years, bike_sales, 3))(
    years
)  # Polynomial trend for electric vehicle sales based on bike sales

# Axes Limits and Labels
xlabel_value = "Year"

ylabel_value_1 = "Sales (in millions)"
ylabel_value_2 = "Electric Vehicle Sales (in millions)"
yticks_values_1 = np.arange(0, 4.1, 0.5)
yticks_values_2 = np.arange(min(electric_vehicle_sales), max(electric_vehicle_sales) + 0.1, 0.2)

# Labels
label_1 = "Car Sales"
label_2 = "Bike Sales"
label_3 = "Electric Vehicle Sales Trend"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# First subplot
ax1.plot(years, car_sales, "o-", color="orange", label=label_1)
ax1.plot(years, bike_sales, "s-", color="blue", label=label_2)
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1)
ax1.set_xticks(years)
ax1.set_yticks(yticks_values_1)
ax1.legend(loc="upper left")
ax1.grid(True)

# Second subplot
ax2.plot(years, bus_sales, "^--", color="green", label="Bus Sales")
ax2.plot(years, electric_vehicle_sales, "*-m", label=label_3)
ax2.set_xlabel(xlabel_value)
ax2.set_ylabel(ylabel_value_2)
ax2.set_xticks(years)
ax2.set_yticks(yticks_values_2)
ax2.legend(loc="upper right")
ax2.grid(True)

# Annotations and styling
for ax in (ax1, ax2):
    ax.spines["left"].set_position(("outward", 10))
    ax.spines["bottom"].set_position(("outward", 10))
    ax.spines["right"].set_color("none")
    ax.spines["top"].set_color("none")
for x, y in zip(years, car_sales):
    ax1.annotate(
        f"{y:.1f}", xy=(x, y), textcoords="offset points", xytext=(0, 10), ha="center"
    )

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('line_42.pdf', bbox_inches='tight')
