import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Generate distinct data sets for each subplot
vehicles = np.array([10, 20, 30, 40, 50, 60])
datasets = {
    "Speed": np.linspace(600, 800, len(vehicles)),  # mph
    "Fuel Efficiency": np.linspace(1000, 650, len(vehicles)),  # mpg
    "Carbon Emissions": np.linspace(700, 800, len(vehicles)),  # g/mile
    "Maintenance Cost": np.linspace(1000, 800, len(vehicles)),  # $/year
}

# Assign each dataset to a subplot
plot_order = ["Speed", "Fuel Efficiency", "Carbon Emissions", "Maintenance Cost"]

# Axes Limits and Labels
xlabel_value = "Number of Vehicles"
ylabel_value = "Metrics"

# Text
text = "Peak Performance"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size and define colors, markers, and linestyles
fig, axs = plt.subplots(2, 2, figsize=(12, 8))  # Use a 2x2 subplot grid
colors = ["deepskyblue", "magenta", "limegreen", "orange"]
markers = ["o", "s", "^", "d"]
linestyles = ["-", "--", ":", "-."]

# Plot data in each subplot
for i, (ax, key) in enumerate(zip(axs.flat, plot_order)):
    for j, data_key in enumerate(plot_order):
        if key == data_key:
            ax.plot(
                vehicles,
                datasets[data_key],
                linestyle=linestyles[j],
                marker=markers[j],
                color=colors[j],
                label=data_key,
                markersize=8,
            )
        else:
            ax.plot(
                vehicles,
                datasets[data_key],
                linestyle=linestyles[j],
                marker=markers[j],
                color=colors[j],
                label=data_key,
                markersize=8,
                alpha=0.8,
            )  # Faded other lines

    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.set_ylim([500, 1200])  
    ax.set_title(f"Graph Variation {i+1}")
    ax.legend()

    # Annotations to explain features, only on primary dataset for clarity
    ax.annotate(
        text,
        xy=(vehicles[-2], datasets[key][-2]),
        xytext=(vehicles[-4], datasets[key][-2] * 1.1),
        arrowprops=dict(arrowstyle="->", color="navy"),
        textcoords="data",
    )

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and ensure clarity
plt.tight_layout()
plt.savefig('line_45.pdf', bbox_inches='tight')
