import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Define a custom color palette
colors = ["#e74c3c", "#3498db", "#2ecc71", "#f39c12", "#9b59b6"]

# Data setup
optimization_levels = np.array([0, 20, 40, 60, 80])
city_mpg = np.array([20, 55, 68, 70, 82])
highway_mpg = np.array([25, 55, 64, 77, 80])
combined_mpg = np.array([72, 107, 150, 173, 286])
electric_range = np.array([50, 100, 150, 200, 250])

# Axes Limits and Labels
xlabel_value = "Engine Optimization Level"
xlim_values = [-5, 85]
ylabel_value = "Efficiency / Range"
ylim_values = [0, 260]

# Labels
label_city_mpg = "City MPG"
label_highway_mpg = "Highway MPG"
label_combined_mpg = "Combined MPG"
label_electric_range = "Electric Range (miles)"

# Titles
title_city_highway = "City vs Highway MPG"
title_combined_electric = "Combined MPG vs Electric Range"
title_all = "All Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the 1x3 subplot configuration
fig, axs = plt.subplots(1, 3, figsize=(9, 3))

# Plot customization for a fancy look
marker_styles = ["o", "^", "s", "x"]
line_styles = ["-", "--", ":", "-."]

# First subplot for city and highway mpg
axs[0].plot(
    optimization_levels,
    city_mpg,
    label=label_city_mpg,
    color=colors[0],
    marker=marker_styles[0],
    linestyle=line_styles[0],
    markersize=10,
    linewidth=2,
)

axs[0].set_title(title_city_highway, fontsize=14)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value, fontsize=12)

# Second subplot for combined mpg and electric range
axs[1].plot(
    optimization_levels,
    highway_mpg,
    label=label_highway_mpg,
    color=colors[1],
    marker=marker_styles[1],
    linestyle=line_styles[1],
    markersize=10,
    linewidth=2,
)
axs[1].set_title(title_combined_electric, fontsize=14)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_value, fontsize=12)

# Third subplot for all metrics
axs[2].plot(
    optimization_levels,
    combined_mpg,
    label=label_combined_mpg,
    color=colors[2],
    marker=marker_styles[2],
    linestyle=line_styles[2],
    markersize=10,
    linewidth=2,
)
axs[2].plot(
    optimization_levels,
    electric_range,
    label=label_electric_range,
    color=colors[3],
    marker=marker_styles[3],
    linestyle=line_styles[3],
    markersize=10,
    linewidth=2,
)
axs[2].set_title(title_all, fontsize=14)
axs[2].set_xlabel(xlabel_value, fontsize=12)
axs[2].set_ylabel(ylabel_value, fontsize=12)

# Set global properties and customize each subplot individually
for ax in axs:
    ax.set_xticks(optimization_levels)
    ax.set_xlim(xlim_values)
    ax.set_ylim(ylim_values)
    ax.legend(loc="lower right", fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no overlap and labels are clearly visible
plt.tight_layout()

# Show the plot
plt.savefig('line_56.pdf', bbox_inches='tight')
