import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Simulated data for transportation metrics
optimization_levels = [0.01, 0.05, 0.1, 0.2]
emission_reduction_64 = np.array([5, 10, 15, 20])
emission_reduction_128 = np.array([6, 12, 18, 22])
emission_reduction_256 = np.array([7, 14, 21, 25])
usage_conditions = [0.0, 0.1, 0.2, 0.3]
fuel_efficiency_64 = np.array([25, 28, 27, 26])
fuel_efficiency_128 = np.array([27, 30, 29, 28])

# Axes Limits and Labels
xlabel_value = "Parameter Rate"

ylabel_value = "Metric"

# Labels
label_1 = " (Engine Size=1.6L)"
label_2 = " (Engine Size=2.0L)"
label_3 = "Emission Reduction vs. Optimization Level"
label_4 = "Fuel Efficiency vs. Usage Conditions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 3x2 grid
fig, axs = plt.subplots(3, 2, figsize=(12, 9))

# Custom colors for the plots
colors = ["dodgerblue", "tomato", "limegreen", "gold", "purple"]

# Function to plot the data
def plot_data(ax, x, y1, y2, title, marker1, marker2, color1, color2):
    ax.plot(
        x,
        y1,
        marker=marker1,
        markersize=8,
        linewidth=2,
        color=color1,
        label=f"{title}{label_1}",
    )
    ax.plot(
        x,
        y2,
        marker=marker2,
        markersize=8,
        linewidth=2,
        color=color2,
        label=f"{title}{label_2}",
    )
    ax.set_title(title, fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel_value, fontsize=12)
    ax.legend(loc="best", fontsize=10, frameon=True, shadow=True)
    ax.grid(True, linestyle="--", alpha=0.5)


# Assigning data to each subplot
plot_data(
    axs[0, 0],
    optimization_levels,
    emission_reduction_64,
    emission_reduction_128,
    label_3,
    "o",
    "s",
    colors[0],
    colors[1],
)
plot_data(
    axs[0, 1],
    usage_conditions,
    fuel_efficiency_64,
    fuel_efficiency_128,
    label_4,
    "^",
    "d",
    colors[2],
    colors[3],
)
plot_data(
    axs[1, 0],
    optimization_levels,
    emission_reduction_128,
    emission_reduction_256,
    label_3,
    ">",
    "<",
    colors[4],
    colors[0],
)
plot_data(
    axs[1, 1],
    usage_conditions,
    fuel_efficiency_128,
    fuel_efficiency_64,
    label_4,
    "p",
    "*",
    colors[1],
    colors[2],
)
plot_data(
    axs[2, 0],
    optimization_levels,
    emission_reduction_256,
    emission_reduction_64,
    label_3,
    "H",
    "X",
    colors[3],
    colors[4],
)
plot_data(
    axs[2, 1],
    usage_conditions,
    fuel_efficiency_64,
    fuel_efficiency_128,
    label_4,
    "+",
    "x",
    colors[0],
    colors[1],
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plots
plt.tight_layout()
plt.savefig('line_57.pdf', bbox_inches='tight')
