import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Enhanced seaborn style for a fancier look
iterations = np.linspace(0, 200, 200)

# Simulated data for transportation metrics
fuel_efficiency_base = np.array([32.65, 30.7, 31.68, 33.7, 33.24, 29.01, 32.06, 30.47, 30.65, 31.54, 31.23, 33.37, 32.39, 31.5, 32.1, 32.03, 33.97, 31.38, 32.31, 30.55, 27.92, 33.16, 33.6, 31.11, 36.09, 30.15, 32.69, 32.41, 35.33, 35.33, 33.27, 33.74, 31.74, 30.02, 32.84, 33.78, 35.69, 35.75, 33.16, 33.41, 32.24, 31.7, 31.3, 37.67, 33.54, 33.77, 32.45, 36.07, 32.01, 34.55, 33.46, 35.81, 34.33, 33.24, 35.38, 36.29, 35.75, 36.27, 34.69, 35.28, 34.82, 35.48, 34.76, 33.2, 36.76, 35.8, 33.65, 37.58, 35.16, 37.03, 38.39, 37.38, 39.36, 35.03, 38.19, 36.25, 36.0, 36.65, 37.25, 38.05, 35.82, 39.86, 39.13, 35.4, 41.3, 42.2, 40.92, 38.4, 36.76, 41.0, 38.26, 41.54, 39.65, 41.27, 40.15, 40.94, 39.67, 43.3, 40.1, 40.75, 43.82, 37.45, 37.69, 42.31, 38.08, 44.49, 39.81, 39.23, 44.78, 43.99, 44.89, 43.02, 39.48, 45.31, 40.9, 43.23, 43.63, 41.44, 43.14, 43.89, 42.85, 39.84, 42.89, 45.17, 40.99, 42.24, 41.74, 46.72, 44.31, 43.84, 41.41, 44.33, 41.81, 43.44, 42.09, 45.04, 44.93, 43.31, 44.74, 41.57, 40.78, 45.14, 44.64, 45.78, 49.77, 46.68, 42.63, 47.27, 41.92, 43.94, 44.92, 49.05, 43.59, 43.5, 45.25, 44.07, 48.25, 43.31, 43.25, 44.97, 44.93, 50.64, 48.48, 46.58, 43.63, 48.55, 44.35, 43.17, 49.67, 47.73, 49.25, 47.94, 49.31, 45.84, 45.03, 49.21, 45.77, 46.14, 46.8, 48.03, 47.24, 44.88, 46.74, 43.01, 50.01, 44.7, 46.0, 48.92, 47.09, 52.77, 45.92, 49.85, 49.2, 46.51, 50.79, 49.17, 51.62, 51.85, 55.3, 53.34])
fuel_efficiency_optimized = np.array([34.35, 34.68, 37.14, 36.46, 36.54, 32.63, 35.56, 34.39, 36.31, 35.73, 37.64, 36.68, 37.63, 35.46, 34.69, 35.76, 36.58, 37.4, 40.97, 36.83, 35.24, 36.47, 36.35, 38.21, 34.53, 37.63, 37.91, 38.15, 36.68, 37.46, 35.31, 37.18, 37.18, 39.11, 36.2, 40.02, 41.5, 34.71, 39.65, 40.24, 37.78, 38.34, 38.96, 38.74, 38.81, 36.21, 41.91, 41.87, 38.2, 37.0, 41.07, 38.97, 40.51, 39.68, 41.82, 41.94, 39.15, 37.91, 37.6, 42.18, 38.59, 40.09, 40.0, 41.22, 37.42, 41.92, 42.72, 41.92, 41.18, 42.14, 42.87, 36.29, 46.37, 43.16, 41.05, 41.71, 43.69, 42.49, 38.49, 47.37, 42.8, 45.34, 41.74, 46.67, 44.06, 44.87, 41.36, 46.39, 45.36, 46.81, 42.66, 43.08, 49.34, 42.0, 44.15, 47.08, 44.87, 46.05, 43.95, 45.78, 42.11, 48.89, 44.98, 43.81, 46.97, 44.5, 42.61, 42.67, 47.44, 45.59, 45.75, 48.64, 43.65, 44.66, 45.56, 46.78, 46.56, 46.09, 46.71, 46.71, 45.37, 45.24, 47.91, 45.25, 44.72, 46.82, 47.29, 53.15, 46.18, 50.23, 49.86, 45.3, 50.13, 45.5, 42.02, 50.04, 44.4, 49.87, 47.2, 53.03, 51.69, 48.06, 47.58, 46.37, 48.38, 48.88, 48.77, 50.16, 51.32, 50.85, 48.16, 46.57, 53.71, 48.64, 48.83, 49.26, 46.01, 49.57, 49.66, 52.56, 52.86, 51.19, 53.67, 52.26, 51.44, 52.0, 51.19, 50.76, 51.19, 49.05, 52.82, 49.59, 54.49, 51.73, 52.62, 53.89, 54.38, 48.64, 52.34, 55.32, 48.58, 54.22, 47.28, 50.66, 53.6, 49.15, 51.05, 49.84, 58.34, 54.44, 55.63, 53.59, 53.34, 50.0, 53.7, 52.52, 57.04, 57.93, 58.93, 57.34])

emission_level_base = np.array([163.23, 152.74, 156.81, 165.97, 162.91, 141.48, 155.55, 147.12, 147.23, 150.77, 148.55, 157.94, 152.58, 147.63, 149.73, 148.67, 156.89, 144.23, 147.75, 139.02, 126.47, 149.45, 150.72, 138.87, 160.31, 133.27, 143.8, 141.88, 153.92, 153.2, 143.57, 144.9, 135.66, 127.67, 139.0, 142.31, 149.63, 149.16, 137.73, 138.08, 132.61, 129.78, 127.55, 152.77, 135.4, 135.66, 129.77, 143.56, 126.81, 136.22, 131.28, 139.84, 133.44, 128.61, 136.24, 139.1, 136.38, 137.73, 131.13, 132.72, 130.39, 132.25, 128.96, 122.59, 135.11, 130.98, 122.54, 136.25, 126.88, 133.01, 137.24, 133.01, 139.42, 123.53, 134.05, 126.66, 125.2, 126.87, 128.37, 130.52, 122.33, 135.49, 132.41, 119.23, 138.49, 140.84, 135.96, 126.99, 121.04, 134.37, 124.82, 134.91, 128.21, 132.82, 128.63, 130.59, 125.95, 136.85, 126.17, 127.64, 136.63, 116.23, 116.47, 130.14, 116.6, 135.63, 120.82, 118.51, 134.68, 131.69, 133.79, 127.64, 116.61, 133.22, 119.73, 125.96, 126.58, 119.67, 124.05, 125.64, 122.1, 113.02, 121.13, 126.99, 114.72, 117.71, 115.77, 129.01, 121.8, 119.98, 112.82, 120.24, 112.89, 116.77, 112.63, 120.01, 119.17, 114.37, 117.61, 108.79, 106.26, 117.09, 115.27, 117.69, 127.38, 118.93, 108.14, 119.38, 105.39, 109.96, 111.93, 121.66, 107.65, 106.95, 110.76, 107.37, 117.05, 104.58, 103.97, 107.64, 107.06, 120.12, 114.48, 109.52, 102.13, 113.13, 102.88, 99.7, 114.19, 109.24, 112.23, 108.74, 111.36, 103.06, 100.79, 109.64, 101.53, 101.89, 102.88, 105.12, 102.92, 97.34, 100.92, 92.46, 107.01, 95.23, 97.56, 103.28, 98.96, 110.42, 95.65, 103.37, 101.56, 95.58, 103.91, 100.14, 104.64, 104.64, 111.09, 106.68])
emission_level_optimized = np.array([137.42, 138.08, 147.17, 143.81, 143.44, 127.53, 138.32, 133.14, 139.92, 137.06, 143.74, 139.41, 142.37, 133.54, 130.04, 133.44, 135.86, 138.3, 150.78, 134.94, 128.52, 132.39, 131.36, 137.45, 123.65, 134.14, 134.51, 134.76, 128.99, 131.13, 123.03, 128.95, 128.38, 134.45, 123.86, 136.33, 140.74, 117.18, 133.23, 134.61, 125.81, 127.12, 128.59, 127.27, 126.95, 117.91, 135.84, 135.11, 122.74, 118.33, 130.76, 123.52, 127.84, 124.66, 130.8, 130.56, 121.36, 116.99, 115.5, 129.0, 117.5, 121.51, 120.71, 123.84, 111.92, 124.84, 126.65, 123.71, 121.0, 123.26, 124.85, 105.23, 133.83, 124.03, 117.45, 118.79, 123.89, 119.95, 108.18, 132.55, 119.24, 125.75, 115.27, 128.3, 120.6, 122.25, 112.2, 125.29, 121.96, 125.3, 113.7, 114.32, 130.35, 110.45, 115.59, 122.73, 116.45, 119.0, 113.07, 117.26, 107.37, 124.13, 113.7, 110.24, 117.66, 111.0, 105.8, 105.5, 116.78, 111.71, 111.61, 118.15, 105.56, 107.53, 109.21, 111.63, 110.62, 109.02, 110.01, 109.51, 105.9, 105.14, 110.85, 104.24, 102.55, 106.9, 107.49, 120.29, 104.04, 112.66, 111.35, 100.72, 110.96, 100.27, 92.19, 109.3, 96.54, 107.96, 101.72, 113.79, 110.42, 102.2, 100.73, 97.75, 101.53, 102.12, 101.43, 103.87, 105.79, 104.36, 98.4, 94.72, 108.76, 98.06, 98.0, 98.42, 91.51, 98.15, 97.9, 103.15, 103.28, 99.57, 103.92, 100.73, 98.72, 99.34, 97.35, 96.1, 96.48, 92.04, 98.65, 92.22, 100.86, 95.33, 96.52, 98.4, 98.86, 88.03, 94.29, 99.21, 86.73, 96.35, 83.64, 89.21, 93.95, 85.77, 88.67, 86.17, 100.41, 93.27, 94.88, 90.99, 90.14, 84.11, 89.92, 87.54, 94.65, 95.67, 96.87, 93.84])

# Axes Limits and Labels
xlabel_value = "Training Iterations"
ylabel_value_1 = "Fuel Efficiency (MPG)"
ylabel_value_2 = "Emission Level (g CO2/mile)"
ylim_values_1 = [25, 60]
ylim_values_2 = [80, 160]

# Labels
labels = ["Base Model", "Optimized Model"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1x2 subplot layout
fig, axs = plt.subplots(1, 2, figsize=(10, 4))

colors = ["#0072B2", "#D55E00"]  # Blue and orange colors for the lines

# Plot the data in each subplot
# Fuel Efficiency
axs[0].plot(
    iterations,
    fuel_efficiency_base,
    label=labels[0],
    color=colors[0],
    marker="o",
    markersize=3,
    linewidth=2,
)
axs[0].plot(
    iterations,
    fuel_efficiency_optimized,
    label=labels[1],
    color=colors[1],
    marker="x",
    markersize=3,
    linewidth=2,
)
axs[0].set_title("Fuel Efficiency Improvement")
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value_1)
axs[0].set_ylim(ylim_values_1)  # Ensure consistent y-axis limits
axs[0].legend(loc="upper right", frameon=True)  # Add a legend

# Emission Level
axs[1].plot(
    iterations,
    emission_level_base,
    label=labels[0],
    color=colors[0],
    marker="o",
    markersize=3,
    linewidth=2,
)
axs[1].plot(
    iterations,
    emission_level_optimized,
    label=labels[1],
    color=colors[1],
    marker="x",
    markersize=3,
    linewidth=2,
)
axs[1].set_title("Emission Level Reduction")
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value_2)
axs[1].set_ylim(ylim_values_2)  # Ensure consistent y-axis limits
axs[1].legend(loc="upper right", frameon=True)  # Add a legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig('line_58.pdf', bbox_inches='tight')
