import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
weeks = np.arange(1, 29)
fuel_efficiency_data = np.array([32.88, 32.57, 34.1, 36.15, 36.37, 33.9, 35.95, 34.72, 34.4, 34.32, 33.26, 33.62, 31.87, 30.12, 29.33, 28.16, 28.38, 25.89, 25.81, 24.27, 22.45, 25.78, 26.36, 25.35, 29.15, 26.38, 28.93, 29.81])
emission_level_data = np.array([138.17, 139.33, 135.14, 139.42, 136.88, 135.65, 148.26, 155.23, 164.83, 168.48, 163.7, 166.51, 164.26, 162.9, 160.97, 177.77, 163.09, 160.28, 152.41, 158.34, 141.93, 144.49, 136.84, 139.46, 131.81, 126.08, 130.36, 132.14])

# Calculate the upper and lower bounds for the data
fuel_efficiency_upper = fuel_efficiency_data + 2
fuel_efficiency_lower = fuel_efficiency_data - 2
emission_level_upper = emission_level_data + 10
emission_level_lower = emission_level_data - 10

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Values"

# Labels
label_fuel_efficiency = "Fuel Efficiency"
label_emission_level = "Emission Level"

# Titles
title = "Fuel Efficiency and Emission Levels Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the fuel efficiency data line and fill the confidence interval
ax.plot(
    weeks,
    fuel_efficiency_data,
    label=label_fuel_efficiency,
    color="deepskyblue",
    marker="o",
    linestyle="-",
)
ax.fill_between(
    weeks, fuel_efficiency_lower, fuel_efficiency_upper, color="deepskyblue", alpha=0.3
)

# Plot the emission level data line and fill the confidence interval
ax.plot(
    weeks,
    emission_level_data,
    label=label_emission_level,
    color="salmon",
    marker="x",
    linestyle="--",
)
ax.fill_between(weeks, emission_level_lower, emission_level_upper, color="salmon", alpha=0.3)

# Customize the plot with labels, title, and legend
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title, fontsize=16)
ax.legend()

# Add a grid to the plot
ax.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig('line_61.pdf', bbox_inches='tight')
