
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Weeks in an educational progress tracking period
# Weeks in a business performance tracking period
weeks = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14]

# Data representing different business trends with varied patterns
sales_revenue = [500, 530, 520, 550, 540, 570, 560, 590, 580, 610, 600, 630, 620, 650]  # rise with fluctuations
customer_satisfaction = [0.75, 0.78, 0.80, 0.82, 0.83, 0.82, 0.80, 0.77, 0.74, 0.70, 0.65, 0.60, 0.55, 0.50]  # initial rise then gradual fall
profit_margin = [750, 740, 720, 710, 690, 680, 660, 650, 630, 620, 600, 590, 570, 560]  # fall with fluctuations

# Extracted variables
xlabel = "Weeks"
ylabel_sales_profit = "Value (in thousands USD)"
ylabel_customer_satisfaction = "Customer Satisfaction (Normalized)"
xlim = (0, 15)
ylim_sales_profit = (480, 780)  # Shared y-limits for sales_revenue and profit_margin
ylim_customer_satisfaction = (0, 1)
title = "Business Trends Over Weeks"
line_label_sales_revenue = "Sales Revenue"
line_label_customer_satisfaction = "Customer Satisfaction"
line_label_profit_margin = "Profit Margin"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot the performance data on the primary y-axis
color = "tab:blue"
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel_sales_profit, color=color)
(line1,) = ax1.plot(
    weeks,
    sales_revenue,
    color=color,
    marker="o",
    linestyle="-",
    clip_on=False,
    zorder=10,
    linewidth=2,
    label=line_label_sales_revenue,
)
ax1.tick_params(axis="y", labelcolor=color)
ax1.set_ylim(ylim_sales_profit)

# Create a secondary y-axis for the efficiency data
ax2 = ax1.twinx()
color = "tab:red"
ax2.set_ylabel(ylabel_customer_satisfaction, color=color)
(line2,) = ax2.plot(
    weeks,
    customer_satisfaction,
    color=color,
    marker="x",
    linestyle="--",
    clip_on=False,
    zorder=10,
    linewidth=2,
    label=line_label_customer_satisfaction,
)
ax2.tick_params(axis="y", labelcolor=color)
ax2.set_ylim(ylim_customer_satisfaction)

# Add a legend to the plot
color = "tab:green"
(line3,) = ax1.plot(
    weeks,
    profit_margin,
    color=color,
    marker="^",
    linestyle=":",
    linewidth=2,
    clip_on=False,
    zorder=10,
    label=line_label_profit_margin,
)
# ax1.legend(loc='upper left')

# Customize the plot with a title, grid, and background color
fig.patch.set_facecolor("#f4f4f4")
ax1.set_facecolor("#e5f5f9")
ax2.set_facecolor("#f9e5e6")
ax1.set_xlim(xlim)
ax1.tick_params(axis="both", which="both", length=0)
ax2.tick_params(axis="both", which="both", length=0)
lines = [line1, line2, line3]
labels = [line.get_label() for line in lines]
fig.legend(
    lines, labels, loc="upper center", bbox_to_anchor=(0.5, 0.95), ncol=3, frameon=False
)
# Set the title and display the plot
plt.title(title, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig('line_62.pdf', bbox_inches='tight')
