import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Simulated data for fuel efficiency (MPG) and maintenance costs ($)
tests = np.arange(1, 11)
model_A_fuel = np.array([31.76, 29.84, 29.87, 30.57, 29.65, 26.24, 27.62, 25.96, 25.45, 25.41])
model_B_fuel = np.array([28.14, 28.9, 27.65, 26.46, 26.22, 25.56, 26.16, 23.91, 23.87, 22.15])
model_C_cost = np.array([348.94, 424.18, 439.51, 418.49, 489.84, 426.47, 467.58, 474.03, 519.54, 529.39])
model_D_cost = np.array([353.1, 368.67, 354.47, 343.72, 387.49, 408.68, 441.27, 451.83, 431.14, 443.95])

# Axes Limits and Labels
xlabel_value = "Test Number"
xticks_values = np.arange(1, 11, 1)

ylabel_value_fuel = "Fuel Efficiency (MPG)"
ylabel_value_cost = "Maintenance Cost ($)"
ylim_values_fuel = [20, 35]
ylim_values_cost = [300, 550]

# Labels
label_model_A = "Model A"
label_model_B = "Model B"
label_model_C = "Model C"
label_model_D = "Model D"

# Titles
title_1 = "Fuel Efficiency Comparison: Model A vs Model B"
title_2 = "Maintenance Cost Comparison: Model C vs Model D"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))

# Plot the fuel efficiency data
ax1.plot(
    tests,
    model_A_fuel,
    marker="s",
    markersize=7,
    color="#2171b5",
    mfc="w",
    mew=2,
    label=label_model_A,
    linewidth=2,
)
ax1.plot(
    tests,
    model_B_fuel,
    marker="D",
    markersize=7,
    color="#bdd7e7",
    mfc="w",
    mew=2,
    label=label_model_B,
    linewidth=2,
)
ax1.set_title(title_1, fontsize=14)
ax1.set_xlabel(xlabel_value, fontsize=12)
ax1.set_ylabel(ylabel_value_fuel, fontsize=12)
ax1.set_ylim(ylim_values_fuel)
ax1.set_xticks(xticks_values)
ax1.legend()
ax1.grid(True, linestyle="--", alpha=0.6)

# Plot the maintenance cost data
ax2.plot(
    tests,
    model_C_cost,
    marker="v",
    markersize=7,
    color="#e7969c",
    mfc="w",
    mew=2,
    label=label_model_C,
    linewidth=2,
)
ax2.plot(
    tests,
    model_D_cost,
    marker="o",
    markersize=7,
    color="#de9ed6",
    mfc="w",
    mew=2,
    label=label_model_D,
    linewidth=2,
)
ax2.set_title(title_2, fontsize=14)
ax2.set_xlabel(xlabel_value, fontsize=12)
ax2.set_ylabel(ylabel_value_cost, fontsize=12)
ax2.set_ylim(ylim_values_cost)
ax2.set_xticks(xticks_values)
ax2.legend()
ax2.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig('line_65.pdf', bbox_inches='tight')
