import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
iterations = np.array([0, 250, 500, 750, 1000, 1250, 1500, 1750, 2000])

# Simulated data for the models with distinct trends
data = {
    "Model A": (
        np.array([0.14, 0.21, 0.33, 0.46, 0.56, 0.61, 0.76, 0.84, 0.95]),np.array([0.16, 0.24, 0.35, 0.43, 0.5, 0.6, 0.68, 0.79, 0.85])
    ),
    "Model B": (
        np.array([0.24, 0.3, 0.39, 0.51, 0.59, 0.62, 0.74, 0.81, 0.9]),np.array([0.26, 0.33, 0.44, 0.5, 0.57, 0.65, 0.73, 0.83, 0.88])
    ),
    "Model C": (
       np.array([0.34, 0.38, 0.46, 0.56, 0.63, 0.64, 0.75, 0.8, 0.88]), np.array([0.21, 0.28, 0.39, 0.45, 0.52, 0.6, 0.68, 0.78, 0.83])
    ),
    "Model D": (
       np.array([0.09, 0.15, 0.26, 0.38, 0.46, 0.5, 0.63, 0.7, 0.8]), np.array([0.11, 0.19, 0.3, 0.37, 0.44, 0.53, 0.62, 0.72, 0.78])
    ),
}
# Axes Limits and Labels
xlabel_value = "Iterations"
xticks_values = np.arange(0, 2250, 250)

ylabel_value = "Success Rate"
ylim_values = [0, 1]

# Labels
label_1 = " Fuel Efficiency Target 1"
label_2 = " Fuel Efficiency Target 2"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(10, 8))

# Plot the data for each model
colors = ["#0a6ae1", "#d75faa"]
markers = ["o", "v"]

# Plot the data for each model
for i, (key, (series1, series2)) in enumerate(data.items()):
    ax = plt.subplot(2, 2, i + 1)
    ax.plot(
        iterations,
        series1,
        marker=markers[0],
        color=colors[0],
        markerfacecolor=colors[0],
        linewidth=2,
        markersize=5,
        label=f"{key}{label_1}",
    )
    ax.plot(
        iterations,
        series2,
        marker=markers[1],
        color=colors[1],
        markerfacecolor=colors[1],
        linewidth=2,
        markersize=5,
        label=f"{key}{label_2}",
    )
    ax.fill_between(
        iterations, series1 - 0.03, series1 + 0.03, color=colors[0], alpha=0.1
    )
    ax.fill_between(
        iterations, series2 - 0.03, series2 + 0.03, color=colors[1], alpha=0.1
    )
    ax.set_title(f"{key} Performance", fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel_value, fontsize=12)
    ax.set_ylim(ylim_values)
    ax.set_xticks(xticks_values)
    ax.legend()
    ax.grid(True, linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig('line_66.pdf', bbox_inches='tight')
