import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
days = np.array([1, 2, 3, 4, 5, 6, 7])
temperature = np.clip(
    20 + np.sin(np.linspace(0, 2 * np.pi, len(days))) * 5
    + np.random.normal(0, 2, len(days)),
    15,
    30,
)
humidity = np.clip(
    60 + np.cos(np.linspace(0, 2 * np.pi, len(days))) * 10
    + np.random.normal(0, 3, len(days)),
    50,
    80,
)
# Axes Limits and Labels
xlabel_value = "Day of the Week"

ylabel_value_1 = "Temperature (°C)"
ylabel_value_2 = "Humidity (%)"

# Labels
label_1 = "Daily Temperature"
label_2 = "Daily Humidity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

(temperature_line,) = ax.plot(
    days,
    temperature,
    "o-",
    color="#ff8b26",
    label=label_1,
    markersize=8,
    linewidth=2,
)
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value_1, fontsize=12)
ax.tick_params(axis="y", direction="in", labelsize=10)
ax.tick_params(axis="x", direction="in", labelsize=10)

# Create a secondary y-axis for Humidity
ax2 = ax.twinx()
(humidity_line,) = ax2.plot(
    days,
    humidity,
    "s--",
    color="#0392fb",
    label=label_2,
    markersize=8,
    linewidth=2,
)
ax2.set_ylabel(ylabel_value_2, fontsize=12)
ax2.tick_params(axis="y", direction="in", labelsize=10)

# Add a legend to the plot
threshold_temp = 25
threshold_humid = 70
ax.axhline(y=threshold_temp, color="red", linestyle="-", linewidth=1.5, label="Temp Threshold")
ax2.axhline(y=threshold_humid, color="green", linestyle="-", linewidth=1.5, label="Humid Threshold")

# Highlight the data points above the threshold
highlight_temp = [2, 4, 6]  # Days to highlight for temperature
highlight_humid = [3, 5, 7]  # Days to highlight for humidity
for day in highlight_temp:
    ax.plot(
        day, temperature[np.where(days == day)], "ro"
    )  # Highlight Temperature
    ax.annotate(
        f"Temp {day}",
        (day, temperature[np.where(days == day)]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )
for day in highlight_humid:
    ax2.plot(
        day, humidity[np.where(days == day)], "go"
    )  # Highlight Humidity
    ax2.annotate(
        f"Humid {day}",
        (day, humidity[np.where(days == day)]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Customize the plot with labels, title, and legend
fig.legend(loc="upper right", bbox_to_anchor=(0.9, 0.9))

# Add a grid to the plot
ax.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig('line_69.pdf', bbox_inches='tight')
