import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Sample data for transportation domain
x1 = np.array([1, 2, 3, 4, 5])
city_mpg = np.array([25, 27, 30, 28, 26])
city_mpg_err = np.array([2, 1.5, 2.5, 2, 1.5])

x2 = np.array([1, 2, 3, 4])
highway_mpg = np.array([30, 32, 34, 33])
highway_mpg_err = np.array([2.5, 2, 2, 1.5])

x3 = np.array([1, 2, 3, 4, 5, 6])
combined_mpg = np.array([27, 28, 29, 27, 26, 25])
combined_mpg_err = np.array([2, 1.5, 2.5, 2, 3, 2.5])

x4 = np.array([1, 2, 3, 4, 5])
efficiency_under_load = np.array([20, 22, 23, 24, 25])
efficiency_under_load_err = np.array([1.5, 2, 2.5, 2, 1.5])

# Axes Limits and Labels
xlim_values_1 = [0.5, 5.5]
xticks_values_1 = np.arange(1, 6)
xlim_values_2 = [0.5, 4.5]
xticks_values_2 = np.arange(1, 5)
xlim_values_3 = [0.5, 6.5]
xticks_values_3 = np.arange(1, 7)
xlim_values_4 = [0.5, 5.5]
xticks_values_4 = np.arange(1, 6)

ylim_values_1 = [20, 35]
yticks_values_1 = np.arange(20, 36, 5)
ylim_values_2 = [20, 35]
yticks_values_2 = np.arange(20, 36, 5)
ylim_values_3 = [20, 35]
yticks_values_3 = np.arange(20, 36, 5)
ylim_values_4 = [15, 30]
yticks_values_4 = np.arange(15, 31, 5)

# Labels
label_city = "City MPG"
label_highway = "Highway MPG"
label_combined = "Combined MPG"
label_load = "Efficiency Under Load"

# Titles
title_city = "(a) City Driving"
title_highway = "(b) Highway Driving"
title_combined = "(c) Combined Efficiency"
title_load = "(d) Efficiency Under Load"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(12, 4))

# Global settings for all axes
for ax in axs:
    ax.tick_params(axis="both", which="major", labelsize=14)

# Plot with error bands
axs[0].errorbar(
    x1, city_mpg, yerr=city_mpg_err, fmt="-o", color="blue", ecolor="#bdbdd7", capsize=5, markersize=4
)
axs[0].fill_between(x1, city_mpg - city_mpg_err, city_mpg + city_mpg_err, color="blue", alpha=0.2)
axs[0].set_title(title_city, y=-0.18, fontsize=16)
axs[0].set_xlim(xlim_values_1)
axs[0].set_ylim(ylim_values_1)
axs[0].set_xticks(xticks_values_1)
axs[0].set_yticks(yticks_values_1)
axs[0].grid(True, alpha=0.5)

axs[1].errorbar(
    x2, highway_mpg, yerr=highway_mpg_err, fmt="-o", color="blue", ecolor="#bdbdd7", capsize=5, markersize=4
)
axs[1].fill_between(x2, highway_mpg - highway_mpg_err, highway_mpg + highway_mpg_err, color="blue", alpha=0.2)
axs[1].set_title(title_highway, y=-0.18, fontsize=16)
axs[1].set_xlim(xlim_values_2)
axs[1].set_ylim(ylim_values_2)
axs[1].set_xticks(xticks_values_2)
axs[1].set_yticks(yticks_values_2)
axs[1].grid(True, alpha=0.5)

axs[2].errorbar(
    x3, combined_mpg, yerr=combined_mpg_err, fmt="-o", color="blue", ecolor="#bdbdd7", capsize=5, markersize=4
)
axs[2].fill_between(x3, combined_mpg - combined_mpg_err, combined_mpg + combined_mpg_err, color="blue", alpha=0.2)
axs[2].set_title(title_combined, y=-0.18, fontsize=16)
axs[2].set_xlim(xlim_values_3)
axs[2].set_ylim(ylim_values_3)
axs[2].set_xticks(xticks_values_3)
axs[2].set_yticks(yticks_values_3)
axs[2].grid(True, alpha=0.5)

axs[3].errorbar(
    x4, efficiency_under_load, yerr=efficiency_under_load_err, fmt="-o", color="blue", ecolor="#bdbdd7", capsize=5, markersize=4
)
axs[3].fill_between(x4, efficiency_under_load - efficiency_under_load_err, efficiency_under_load + efficiency_under_load_err, color="blue", alpha=0.2)
axs[3].set_title(title_load, y=-0.18, fontsize=16)
axs[3].set_xlim(xlim_values_4)
axs[3].set_ylim(ylim_values_4)
axs[3].set_xticks(xticks_values_4)
axs[3].set_yticks(yticks_values_4)
axs[3].grid(True, alpha=0.5)

# Adjust layout
plt.subplots_adjust(wspace=0.3)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig('line_7.pdf', bbox_inches='tight')
