import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
sensors = np.array([2, 3, 4, 5, 6, 7, 8])
fuel_efficiency = np.array(
    [30.88, 34.53, 34.82, 31.12, 28.0, 28.0, 30.48]
)
emission_levels = np.array(
    [180.0, 199.48, 220.0, 200.72, 187.27, 203.81, 220.0]
)
highlight = [3, 5, 6]

# Axes Limits and Labels
xlabel_value = "Number of Sensors"
ylabel_value_1 = "Fuel Efficiency (MPG)"
ylabel_value_2 = "Emission Levels (g CO2/mile)"

# Labels
label_1 = "Fuel Efficiency"
label_2 = "Threshold"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 1x2 grid
fig, axs = plt.subplots(1, 2, figsize=(12, 5))

# Plot the Fuel Efficiency data
(fuel_line,) = axs[0].plot(
    sensors,
    fuel_efficiency,
    "o-",
    color="#ffd638",
    label="Fuel Efficiency",
    markersize=8,
    linewidth=2,
)
axs[0].set_xlabel(xlabel_value, fontsize=12)
axs[0].set_ylabel(ylabel_value_1, fontsize=12)
axs[0].tick_params(axis="y", direction="in", labelsize=10)
axs[0].tick_params(axis="x", direction="in", labelsize=10)

# Plot the Emission Levels data
(emission_line,) = axs[1].plot(
    sensors,
    emission_levels,
    "s--",
    color="green",
    label="Emission Levels",
    markersize=8,
    linewidth=2,
)
axs[1].set_xlabel(xlabel_value, fontsize=12)
axs[1].set_ylabel(ylabel_value_2, fontsize=12)
axs[1].tick_params(axis="y", direction="in", labelsize=10)
axs[1].tick_params(axis="x", direction="in", labelsize=10)

# Add a threshold line
threshold_fuel = 34
threshold_emission = 190
axs[0].axhline(y=threshold_fuel, color="red", linestyle="-", linewidth=1.5, label=label_2)
axs[1].axhline(y=threshold_emission, color="red", linestyle="-", linewidth=1.5, label=label_2)

# Highlight the data points above the threshold
for mic in highlight:
    axs[0].plot(
        mic, fuel_efficiency[np.where(sensors == mic)], "ro"
    )  # Highlight Fuel Efficiency
    axs[0].annotate(
        f"Highlight {mic}",
        (mic, fuel_efficiency[np.where(sensors == mic)]),
        textcoords="offset points",
        xytext=(0, -20),
        ha="center",
    )
    axs[1].plot(
        mic, emission_levels[np.where(sensors == mic)], "ro"
    )  # Highlight Emission Levels
    axs[1].annotate(
        f"Highlight {mic}",
        (mic, emission_levels[np.where(sensors == mic)]),
        textcoords="offset points",
        xytext=(0, -20),
        ha="center",
    )

# Customize the plot with labels, title, and legend
axs[0].legend()
axs[1].legend()

# Add a grid to the plot
for ax in axs:
    ax.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig('line_70.pdf', bbox_inches='tight')
