import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

import squarify
from matplotlib.gridspec import GridSpec

# ===================
# Part 2: Data Preparation
# ===================
# Treemap data for energy resources allocation by region
sizes_treemap = [50, 20, 15, 10, 3, 2]
labels_treemap = [
    "Coal\n50%",
    "Natural Gas\n20%",
    "Hydro\n15%",
    "Solar\n10%",
    "Wind\n3%",
    "Others\n2%",
]
colors_treemap = ["#8dd3c7", "#ffffb3", "#bebada", "#fb8072", "#80b1d3", "#fdb462"]

# Pie chart data for renewable energy adoption rates in regions
sizes_pie = [45, 25, 15, 10, 5]
labels_pie = ["North", "South", "East", "West", "Central"]
colors_pie = plt.cm.Set3(np.linspace(0, 1, len(sizes_pie)))
explode_pie = (0.1, 0, 0, 0, 0)  # Highlight the first slice

title = "Renewable Energy Adoption Rate by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and set GridSpec
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

# Create treemap subplot
ax1 = fig.add_subplot(gs[0, 0])
squarify.plot(
    sizes=sizes_treemap,
    label=labels_treemap,
    color=colors_treemap,
    alpha=0.7,
    text_kwargs={"fontsize": 14},
)
ax1.axis("off")  # Disable the axes

# Create pie chart subplot
ax2 = fig.add_subplot(gs[0, 1])
wedges, texts, autotexts = ax2.pie(
    sizes_pie,
    explode=explode_pie,
    labels=labels_pie,
    colors=colors_pie,
    autopct="%1.1f%%",
    shadow=True,
    startangle=90,
)
ax2.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig('multidiff_1.pdf', bbox_inches='tight')
