import numpy as np; np.random.seed(0); np.random.seed(0)

import matplotlib.pyplot as plt
from matplotlib.gridspec import GridSpec
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
# Create a figure and a GridSpec layout
fig = plt.figure(figsize=(10, 5))
gs = GridSpec(1, 2, figure=fig)

# ------- Pie Chart Data for Business Revenue Sources -------
categories = ["Product Sales", "Service Fees", "Subscriptions", "Advertisements", "Investments"]
sizes = [35, 25, 20, 10, 10]  # Percentages of each revenue source
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0"]
explode = (0.1, 0, 0, 0, 0)  # Highlight Product Sales

# ------- Radar Chart Data for Key Performance Indicators (KPIs) -------
labels = np.array(["Growth", "Profitability", "Customer Satisfaction", "Market Share", "Employee Engagement"])
num_vars = len(labels)
values = np.array([0.8, 0.7, 0.9, 0.6, 0.85])
values = np.concatenate((values, [values[0]]))
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
angles += angles[:1]

title_1 = "Distribution of Business Revenue Sources"
title_2 = "Key Performance Indicators (KPIs)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the pie chart in the left panel
ax1 = fig.add_subplot(gs[0, 0])
wedges, texts, autotexts = ax1.pie(
    sizes,
    labels=categories,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    explode=explode,
)
ax1.set_title(title_1)
ax1.axis("equal")  # Equal aspect ratio ensures that pie is drawn as a circle.

# Create the radar chart in the right panel
ax2 = fig.add_subplot(gs[0, 1], polar=True)
ax2.fill(angles, values, color="blue", alpha=0.25)
ax2.plot(angles, values, color="blue", linewidth=1)
ax2.set_xticks(angles[:-1])
ax2.set_xticklabels(labels)
ax2.set_title(title_2)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('multidiff_24.pdf', bbox_inches='tight')
