import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Assuming data values for the bar chart
categories = [
    "CPU Utilization",
    "Memory Usage",
    "Disk I/O",
    "Network Throughput",
    "Latency",
    "Error Rate",
]
values = [0.9, 0.8, 0.7, 0.6, 0.5, 0.3]

# Generate y values for the line chart with a monotonically decreasing array
# Creating arrays for y values with 26 numbers each and random add or subtract 0.01 to make them different
cpu_performance = np.array([0.34, 0.32, 0.32, 0.31, 0.3, 0.28, 0.28, 0.26, 0.26, 0.25, 0.24, 0.24, 0.22, 0.21, 0.2, 0.19, 0.19, 0.17, 0.17, 0.15, 0.13, 0.14, 0.13, 0.11, 0.12, 0.09])
memory_performance = np.array([0.36, 0.34, 0.34, 0.34, 0.33, 0.3, 0.3, 0.28, 0.28, 0.27, 0.26, 0.26, 0.24, 0.23, 0.22, 0.21, 0.21, 0.19, 0.19, 0.17, 0.15, 0.16, 0.15, 0.13, 0.15, 0.11])
disk_io_performance = np.array([0.33, 0.31, 0.31, 0.31, 0.29, 0.27, 0.27, 0.25, 0.25, 0.24, 0.23, 0.23, 0.21, 0.2, 0.19, 0.18, 0.18, 0.16, 0.16, 0.14, 0.12, 0.13, 0.12, 0.1, 0.11, 0.08])
network_throughput_performance = np.array([0.35, 0.33, 0.33, 0.33, 0.31, 0.28, 0.29, 0.27, 0.26, 0.25, 0.24, 0.24, 0.22, 0.21, 0.2, 0.19, 0.19, 0.16, 0.16, 0.14, 0.11, 0.13, 0.12, 0.09, 0.11, 0.07])
latency_performance = np.array([0.32, 0.3, 0.29, 0.29, 0.28, 0.26, 0.26, 0.24, 0.23, 0.23, 0.21, 0.21, 0.2, 0.19, 0.18, 0.17, 0.16, 0.15, 0.14, 0.12, 0.11, 0.11, 0.1, 0.09, 0.09, 0.06])
error_rate_performance = np.array([0.38, 0.35, 0.34, 0.34, 0.33, 0.29, 0.3, 0.27, 0.26, 0.26, 0.24, 0.24, 0.22, 0.21, 0.2, 0.18, 0.18, 0.15, 0.15, 0.12, 0.1, 0.11, 0.1, 0.08, 0.09, 0.05])

# Axes Limits and Labels
xlabel_value_1 = "Performance Score"
xlim_values_1 = [0, 1]
xticks_all_1 = np.arange(0, 1.05, 0.05)
xticks_labeled_1 = np.arange(0, 1.1, 0.2)

xticks_2 = np.arange(0, 26, 1)
label_cpu = "CPU Utilization"
label_memory = "Memory Usage"
label_disk_io = "Disk I/O"
label_network_throughput = "Network Throughput"
ax2_label_latency = "Latency"
ax2_label_error_rate = "Error Rate"
xlabel_value_2 = "Iterations"
ylabel_value_2 = "Performance Metric"
ylim_values_2 = [0, 0.37]
xticks_all_2 = np.arange(0, 26, 1)
xticks_labeled_2 = np.arange(0, 26, 5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create bar chart
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(7, 9))
ax1.barh(categories, values, color="#6194bf")
ax1.set_xlabel(xlabel_value_1)
ax1.set_xlim(xlim_values_1)

# Add more x-ticks but only label some of them
all_xticks = xticks_all_1
labeled_xticks = xticks_labeled_1
ax1.set_xticks(all_xticks)
ax1.set_xticklabels(
    [f"{tick:.1f}" if tick in labeled_xticks else "" for tick in all_xticks]
)

# Create line chart
trials = xticks_2
ax2.plot(trials, cpu_performance, label=label_cpu, color="blue")
ax2.plot(trials, memory_performance, label=label_memory, color="green")
ax2.plot(trials, disk_io_performance, label=label_disk_io, color="orange")
ax2.plot(trials, network_throughput_performance, label=label_network_throughput, color="purple", linestyle=":")
ax2.plot(
    trials,
    latency_performance,
    label=ax2_label_latency,
    color="purple",
    linestyle="--",
)
ax2.plot(
    trials, error_rate_performance, label=ax2_label_error_rate, color="purple", linestyle="-"
)
ax2.set_xlabel(xlabel_value_2)
ax2.set_ylabel(ylabel_value_2)

# Set the y limit to match the uploaded image aspect
ax2.set_ylim(ylim_values_2)
ax2.legend(loc="upper right", frameon=False)
all_xticks = xticks_all_2
labeled_xticks = xticks_labeled_2
ax2.set_xticks(all_xticks)
ax2.set_xticklabels(
    [f"{tick}" if tick in labeled_xticks else "" for tick in all_xticks]
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('multidiff_8.pdf', bbox_inches='tight')
