
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for the charts
categories = ["Cars", "Bicycles", "Public Transport", "Walking"]
urban_transport_data_2020 = [40.5, 12.3, 30.8, 16.4]
urban_transport_data_2024 = [33.2, 17.1, 36.6, 13.1]

urban_transport_2020_label = 'Urban Transport 2020'
urban_transport_2024_label = 'Urban Transport 2024'
title_urban_transport_2020 = "Urban Transport in 2020"
title_urban_transport_2024 = "Urban Transport in 2024"

legend_labels = categories


colors = ["#FFD580", "#C0C0C0", "#8FBC8F", "#ebf5a4"]
# Variables for plot configuration
legend_loc = "lower center"
legend_ncol = 4
legend_frameon = False
wedgeprops_dict = dict(width=0.3)
startangle = 90
counterclock = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(2, 1, figsize=(5, 8))

# Full Finetuning Donut Chart
ax[0].pie(
    urban_transport_data_2020,
    labels=categories,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[0].set_title(title_urban_transport_2020)

# QLoRA Donut Chart
ax[1].pie(
    urban_transport_data_2024,
    labels=categories,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[1].set_title(title_urban_transport_2024)

# Add legend
fig.legend(legend_labels, loc=legend_loc, ncol=legend_ncol, frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig('pie_13.pdf', bbox_inches='tight')
