# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data to plot
sizes = [45.2, 20.8, 18.3, 10.4, 3.2, 2.1]  # Example data related to user's social media platform usage
labels = ["Platform X", "Platform Y", "Platform Z", "Platform W", "Platform V", "Others"]

# Extracted variables
title = "User's Social Media Platform Usage"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(7, 7))

title_pad = 20
autopct_format = "%1.1f%%"
startangle = 90
wedgeprops = dict(edgecolor="w")

colors = ["#FF6347", "#FF7F50", "#FFD700", "#ADFF2F", "#32CD32", "#00FA9A"]
explode = (0.1, 0, 0, 0, 0, 0.2)  # add explode parameter to separate slices

ax.pie(
    sizes,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    wedgeprops=wedgeprops,
    explode=explode,
    labels=labels
)
ax.set_title(title, pad=title_pad)  # Set the title with padding

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig('pie_17.pdf', bbox_inches='tight')