# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)

# Data to plot
labels = ["Research", "Administration", "Teaching", "Personnel", "Maintenance"]
sizes = [40, 10, 25, 15, 10]

# Extracted variables
title_text = "Budget Allocation by Department"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 6))

colors = plt.cm.Paired(np.linspace(0.3, 1, len(sizes)))
explode = (0.1, 0, 0.1, 0, 0)  # Highlight the two largest segments
legend_location = "upper right"
legend_fontsize = 10
title_fontsize = 16
title_y_position = 1.05
autopct_format = "%1.1f%%"
shadow_effect = True
start_angle = 90

plt.pie(
    sizes,
    explode=explode,
    colors=colors,
    autopct=autopct_format,
    shadow=shadow_effect,  # Add shadow for depth
    startangle=start_angle
)
plt.axis("equal")

# Add legend
plt.legend(labels, loc=legend_location, fontsize=legend_fontsize)
plt.title(title_text, fontsize=title_fontsize, y=title_y_position)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('pie_20.pdf', bbox_inches='tight')