import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Different data for another example
labels = ["iOS", "Android", "Web", "Desktop", "Other"]
outer_sizes = [350, 450, 200, 120, 80]  # usage of platforms in a tech company
inner_sizes = [150, 250, 120, 60, 20]  # usage of platforms for a specific project

outer_colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0"]
inner_colors = ["#c4e17f", "#76dd1e", "#5a69af", "#edc214", "#ebefc9"]

explode_outer = (0.1, 0, 0, 0, 0)  # only explode the 1st slice (IOS)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6))

# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=labels,
    radius=1.2,
    colors=outer_colors,
    explode=explode_outer,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=160,
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    radius=0.8,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=160,
)

# Equal aspect ratio ensures that pie chart is drawn as a circle
ax.axis("equal")

# Title for the double layer pie chart
ax.set_title("Platform Usage - Company vs. Project", fontsize=20, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('pie_9.pdf', bbox_inches='tight')
