import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
cities_1 = ["Berlin", "Paris", "London"]
summer_avg_temp_1 = [19.5, 20.3, 18.2]
summer_temp_change_1 = [5.1, 3.8, 4.3]
winter_avg_temp_1 = [3.0, 5.2, 4.8]
winter_temp_change_1 = [1.5, -2.3, 3.0]
ax1_labels = ["Summer Temp\nChange (°C)", "Winter Temp\nChange (°C)"]

cities_2 = ["Tokyo", "Seoul", "Beijing"]
summer_avg_temp_2 = [25.2, 24.5, 26.1]
summer_temp_change_2 = [1.5, 1.7, 2.0]
winter_avg_temp_2 = [5.8, 1.5, 2.0]
winter_temp_change_2 = [4.0, 1.8, 2.8]
ax2_labels = ["Summer Temp\nChange (°C)", "Winter Temp\nChange (°C)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with two subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 4))

# Set the y-axis offsets to be in the middle of each grid
offset = 0.5

# First subplot (cities_1)
for i, city in enumerate(cities_1):
    # Summer temp change line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(summer_avg_temp_1[i], i + offset * 3 / 2),
        xytext=(summer_avg_temp_1[i] + summer_temp_change_1[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color="red"),
    )
    ax1.scatter(
        [summer_avg_temp_1[i], summer_avg_temp_1[i] + summer_temp_change_1[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=10,
    )
    ax1.annotate(
        f"{summer_temp_change_1[i]:.1f}°C",
        (summer_avg_temp_1[i] + summer_temp_change_1[i], i + offset * 1.75),
        color="red",
        ha="right",
        va="center",
    )

    # Winter temp change line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(winter_avg_temp_1[i], i + offset / 2),
        xytext=(winter_avg_temp_1[i] + winter_temp_change_1[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color="blue"),
    )
    ax1.scatter(
        [winter_avg_temp_1[i], winter_avg_temp_1[i] + winter_temp_change_1[i]],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=10,
    )
    ax1.annotate(
        f"{winter_temp_change_1[i]:.1f}°C",
        (winter_avg_temp_1[i] + winter_temp_change_1[i], i + offset * 0.75),
        color="blue",
        ha="left",
        va="center",
    )

# Second subplot (cities_2)
for i, city in enumerate(cities_2):
    ax2.annotate(
        "",
        xy=(summer_avg_temp_2[i], i + offset * 3 / 2),
        xytext=(summer_avg_temp_2[i] + summer_temp_change_2[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color="red"),
    )
    ax2.scatter(
        [summer_avg_temp_2[i], summer_avg_temp_2[i] + summer_temp_change_2[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=10,
    )
    ax2.annotate(
        f"{summer_temp_change_2[i]:.1f}°C",
        (summer_avg_temp_2[i] + summer_temp_change_2[i], i + offset * 1.75),
        color="red",
        ha="right",
        va="center",
    )

    ax2.annotate(
        "",
        xy=(winter_avg_temp_2[i], i + offset / 2),
        xytext=(winter_avg_temp_2[i] + winter_temp_change_2[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color="blue"),
    )
    ax2.scatter(
        [winter_avg_temp_2[i], winter_avg_temp_2[i] + winter_temp_change_2[i]],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=10,
    )
    ax2.annotate(
        f"{winter_temp_change_2[i]:.1f}°C",
        (winter_avg_temp_2[i] + winter_temp_change_2[i], i + offset * 0.75),
        color="blue",
        ha="left",
        va="center",
    )

# set y-axis limits
ax1.set_ylim(0, len(cities_1))
ax2.set_ylim(0, len(cities_2))

# Set x-axis limits uniformly
ax1.set_xlim(0, 30)
ax2.set_xlim(0, 30)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(cities_1))])
ax1.set_yticklabels(cities_1)
ax2.set_yticks([i + offset for i in range(len(cities_2))])
ax2.set_yticklabels(cities_2)
ax2.yaxis.tick_right()
ax2.yaxis.set_label_position("right")

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(cities_1))], minor=True)
ax2.set_yticks([i for i in range(len(cities_2))], minor=True)
ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")
ax2.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")

# add x-axis grid lines and set gap is 1
ax1.xaxis.set_major_locator(plt.MultipleLocator(2))
ax2.xaxis.set_major_locator(plt.MultipleLocator(2))
ax1.grid(axis="x", linestyle="--", linewidth=0.5)
ax2.grid(axis="x", linestyle="--", linewidth=0.5)

# Create arrow-shaped legend entries with a line that aligns with the arrowhead
red_arrow = mlines.Line2D(
    [],
    [],
    color="red",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
blue_arrow = mlines.Line2D(
    [],
    [],
    color="blue",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[red_arrow, blue_arrow], bbox_to_anchor=(0.45, 0), ncol=2)

red_arrow = mlines.Line2D(
    [],
    [],
    color="red",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
blue_arrow = mlines.Line2D(
    [],
    [],
    color="blue",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[red_arrow, blue_arrow], bbox_to_anchor=(0.85, 0), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig('quiver_1.pdf', bbox_inches='tight')
