import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
athletes_1 = ["Athlete A", "Athlete B", "Athlete C"]
performance_start_1 = [8.2, 8.7, 9.0]
improvement_1 = [+1.3, +1.5, +1.0]
baseline_start_1 = [7.0, 7.5, 8.0]
decline_1 = [-1.0, -1.2, -0.8]

athletes_2 = ["Athlete D", "Athlete E", "Athlete F"]
performance_start_2 = [9.5, 9.0, 8.8]
improvement_2 = [+1.0, +1.2, +1.1]
baseline_start_2 = [8.2, 8.5, 8.0]
decline_2 = [-0.8, -1.0, -0.9]

# Axes Limits and Labels
xlim_values = [5, 11]
label = "Performance Change\n(Sports)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with two subplots
fig, ax1 = plt.subplots(figsize=(5, 4))

# Set the y-axis offsets to be in the middle of each grid
offset = 0.5

# First subplot (athletes_1)
for i, athlete in enumerate(athletes_1):
    # Performance improvement line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(performance_start_1[i], i + offset * 3 / 2),
        xytext=(performance_start_1[i] + improvement_1[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color="red"),
    )
    ax1.scatter(
        [performance_start_1[i], performance_start_1[i] + improvement_1[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=10,
    )
    ax1.annotate(
        f"{improvement_1[i]:.2f}",
        (performance_start_1[i] + improvement_1[i], i + offset * 1.75),
        color="red",
        ha="right",
        va="center",
    )

# set y-axis limits
ax1.set_ylim(0, len(athletes_1))

# Set x-axis limits uniformly
ax1.set_xlim(xlim_values)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(athletes_1))])
ax1.set_yticklabels(athletes_1)

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(athletes_1))], minor=True)

ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")

# add x-axis grid lines and set gap is 1
ax1.xaxis.set_major_locator(plt.MultipleLocator(1))

ax1.grid(axis="x", linestyle="--", linewidth=0.5)

# Create arrow-shaped legend entries with a line that aligns with the arrowhead
green_arrow = mlines.Line2D(
    [],
    [],
    color="red",
    marker=">",
    linestyle="-",
    markersize=8,
    label=label,
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)

fig.legend(handles=[green_arrow], bbox_to_anchor=(0.45, 0), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig('quiver_2.pdf', bbox_inches='tight')
