import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

import matplotlib.lines as mlines
import matplotlib.patches as mpatches


# ===================
# Part 2: Data Preparation
# ===================
# Define the vector field function for wind
def wind_vector_field(X, Y):
    # Example function simulating wind directions
    U = -Y
    V = X
    return U, V


def modified_wind_vector_field(X, Y):
    # Example modification to wind directions
    U = -1 - X**2 + Y
    V = 1 + X - Y**2
    return U, V


# Create a grid of points
x = np.linspace(0, 0.6, 10)
y = np.linspace(0, 0.6, 10)
X, Y = np.meshgrid(x, y)

# Compute the wind vector field
U, V = wind_vector_field(X, Y)

# Compute the modified wind vector field
U_mod, V_mod = modified_wind_vector_field(X, Y)

# Plot temperature variations as curves with slightly different denominators for variation
x = np.linspace(0.2, 0.5, 100)
xlabel = "Longitude"
ylabel = "Latitude"
patch_labels = ["Original Wind Field", "Modified Wind Field"]
line_labels = ["Summer Temperature", "Winter Temperature", "Spring Temperature", "Autumn Temperature"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.quiver(X, Y, U, V, color="#f15b50", alpha=0.6)
plt.quiver(X, Y, U_mod, V_mod, color="#6e5dc6", alpha=0.6)
plt.plot(x, 0.09 / (x**1.2), color="#3b75af", label=line_labels[0])
plt.plot(x, 0.08 / (x**1.2 + 0.04), color="#ef8636", label=line_labels[1])
plt.plot(x, 0.075 / (x**1 + 0.04), color="#519e3e", label=line_labels[2])
plt.plot(x, 0.12 / (x**1 + 0.05), color="#000000", label=line_labels[3])

# Add labels and legend
plt.xlabel(xlabel, fontsize=14, style="italic")
plt.ylabel(ylabel, fontsize=14, style="italic")

red_patch = mpatches.Patch(color="#f15b50", label=patch_labels[0], alpha=0.6)
blue_patch = mpatches.Patch(color="#6e5dc6", label=patch_labels[1], alpha=0.6)

# Create legend for curves
summer_line = mlines.Line2D([], [], color="#3b75af", label=line_labels[0])
winter_line = mlines.Line2D([], [], color="#ef8636", label=line_labels[1])
spring_line = mlines.Line2D([], [], color="#519e3e", label=line_labels[2])
autumn_line = mlines.Line2D([], [], color="#000000", label=line_labels[3])

# Combine all legend handles
handles = [
    red_patch,
    blue_patch,
    summer_line,
    winter_line,
    spring_line,
    autumn_line,
]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig('quiver_3.pdf', bbox_inches='tight')
