# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot (Energy Domain)
brands_beverages = ["Coca-Cola", "Pepsi", "Nescafe"]
market_share_start_beverages = [15, 5, 4.9]
market_share_change_beverages = [12, 12, 15]
revenue_start_beverages = [50, 70, 60]
revenue_change_beverages = [9, 7, 8]
beverages_labels = ["Revenue Growth", "Market Share Growth"]

brands_air_conditioners = ["Gree", "Midea", "Hisense"]
market_share_start_air_conditioners = [20, 16, 22]
market_share_change_air_conditioners = [6, 7, 5]
revenue_start_air_conditioners = [56, 57, 62]
revenue_change_air_conditioners = [4, 7, 6]
air_conditioners_labels = ["Revenue Growth", "Market Share Growth"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with two subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))

# Set the y-axis offsets to be in the middle of each grid
offset = 0.5

# First subplot (brands_beverages)
for i, brand in enumerate(brands_beverages):
    # Revenue line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(revenue_start_beverages[i], i + offset * 3 / 2),
        xytext=(revenue_start_beverages[i] + revenue_change_beverages[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color="gray"),
    )
    ax1.scatter(
        [revenue_start_beverages[i], revenue_start_beverages[i] + revenue_change_beverages[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=10,
    )
    ax1.annotate(
        f"{revenue_change_beverages[i]:.2f}",
        (revenue_start_beverages[i] + revenue_change_beverages[i], i + offset * 1.75),
        color="gray",
        ha="right",
        va="center",
    )

    # Market share line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(market_share_start_beverages[i], i + offset / 2),
        xytext=(market_share_start_beverages[i] + market_share_change_beverages[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color="darkorchid"),
    )
    ax1.scatter(
        [market_share_start_beverages[i], market_share_start_beverages[i] + market_share_change_beverages[i]],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=10,
    )
    ax1.annotate(
        f"{market_share_change_beverages[i]:.2f}",
        (market_share_start_beverages[i] + market_share_change_beverages[i], i + offset * 0.75),
        color="darkorchid",
        ha="left",
        va="center",
    )

# Second subplot (brands_air_conditioners)
for i, brand in enumerate(brands_air_conditioners):
    ax2.annotate(
        "",
        xy=(revenue_start_air_conditioners[i], i + offset * 3 / 2),
        xytext=(revenue_start_air_conditioners[i] + revenue_change_air_conditioners[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<-", color="gray"),
    )
    ax2.scatter(
        [revenue_start_air_conditioners[i], revenue_start_air_conditioners[i] + revenue_change_air_conditioners[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=10,
    )
    ax2.annotate(
        f"{revenue_change_air_conditioners[i]:.2f}",
        (revenue_start_air_conditioners[i] + revenue_change_air_conditioners[i], i + offset * 1.75),
        color="gray",
        ha="right",
        va="center",
    )

    ax2.annotate(
        "",
        xy=(market_share_start_air_conditioners[i], i + offset / 2),
        xytext=(market_share_start_air_conditioners[i] + market_share_change_air_conditioners[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color="darkorchid"),
    )
    ax2.scatter(
        [market_share_start_air_conditioners[i], market_share_start_air_conditioners[i] + market_share_change_air_conditioners[i]],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=10,
    )
    ax2.annotate(
        f"{market_share_change_air_conditioners[i]:.2f}",
        (market_share_start_air_conditioners[i] + market_share_change_air_conditioners[i], i + offset * 0.75),
        color="darkorchid",
        ha="left",
        va="center",
    )

# Set y-axis limits
ax1.set_ylim(0, len(brands_beverages))
ax2.set_ylim(0, len(brands_air_conditioners))

# Set x-axis limits uniformly
ax1.set_xlim(0, 100)
ax2.set_xlim(0, 100)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(brands_beverages))])
ax1.set_yticklabels(brands_beverages)
ax2.set_yticks([i + offset for i in range(len(brands_air_conditioners))])
ax2.set_yticklabels(brands_air_conditioners)
ax2.yaxis.tick_right()
ax2.yaxis.set_label_position("right")

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(brands_beverages))], minor=True)
ax2.set_yticks([i for i in range(len(brands_air_conditioners))], minor=True)
ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")
ax2.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")

# Add x-axis grid lines and set gap to 10
ax1.xaxis.set_major_locator(plt.MultipleLocator(10))
ax2.xaxis.set_major_locator(plt.MultipleLocator(10))
ax1.grid(axis="x", linestyle="--", linewidth=0.5)
ax2.grid(axis="x", linestyle="--", linewidth=0.5)

# Create arrow-shaped legend entries with a line that aligns with the arrowhead
gray_arrow = mlines.Line2D(
    [],
    [],
    color="gray",
    marker=">",
    linestyle="-",
    markersize=8,
    label=beverages_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
darkorchid_arrow = mlines.Line2D(
    [],
    [],
    color="darkorchid",
    marker=">",
    linestyle="-",
    markersize=8,
    label=beverages_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[gray_arrow, darkorchid_arrow], bbox_to_anchor=(0.45, 0), ncol=2)

gray_arrow = mlines.Line2D(
    [],
    [],
    color="gray",
    marker=">",
    linestyle="-",
    markersize=8,
    label=air_conditioners_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
darkorchid_arrow = mlines.Line2D(
    [],
    [],
    color="darkorchid",
    marker=">",
    linestyle="-",
    markersize=8,
    label=air_conditioners_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[gray_arrow, darkorchid_arrow], bbox_to_anchor=(0.85, 0), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig('quiver_7.pdf', bbox_inches='tight')