
import numpy as np; np.random.seed(0); np.random.seed(0)
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
categories = [
    "Innovation",
    "Reliability",
    "User Experience",
    "Security",
    "Performance",
    "Scalability",
    "Support",
    "Cost Efficiency",
    "Compliance",
]
values1 = [35, 42, 28, 30, 40, 45, 43, 38, 44]  # TechA
values2 = [29, 32, 36, 33, 27, 47, 46, 31, 34]  # TechB
# Number of variables
num_vars = len(categories)

# Compute angle for each category
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
values1 += values1[:1]
values2 += values2[:1]
angles += angles[:1]

# Extracted variables
line_label1 = 'TechA'
line_label2 = 'TechB'
xticks_labels = categories
yticks_values = [10, 20, 30, 40, 50]
yticks_labels = []
ylim_values = (0, 50)
title_text = "TechA vs TechB in Performance Criteria"

title_size = 14
title_color = "black"
title_y = 1.1
legend_loc = "lower center"
legend_ncol = 2
legend_bbox_to_anchor = (0.5, -0.2)
legend_fontsize = "small"
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels, aligned vertically
plt.xticks(angles[:-1], xticks_labels, color="black", size=10, ha="center")

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks_values, yticks_labels, color="grey", size=7)
plt.ylim(ylim_values)

# Plot data with markers and new colors
ax.plot(
    angles,
    values2,
    linewidth=1,
    linestyle="solid",
    marker="o",
    label=line_label2,
    color="#ff6347",
)
ax.fill(angles, values2, "#ff6347", alpha=0.2)

ax.plot(
    angles,
    values1,
    linewidth=1,
    linestyle="solid",
    marker="s",
    label=line_label1,
    color="#556b2f",
)
ax.fill(angles, values1, "#556b2f", alpha=0.2)

# Add a title to the radar chart
plt.title(title_text, size=title_size, color=title_color, y=title_y)

# Add legend
plt.legend(
    loc=legend_loc,
    ncol=legend_ncol,
    bbox_to_anchor=legend_bbox_to_anchor,
    fontsize=legend_fontsize,
    frameon=legend_frameon,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig('radar_15.pdf', bbox_inches='tight')
