
import numpy as np; np.random.seed(0); np.random.seed(0)

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
categories = [
    "Revenue Growth",
    "Market Share",
    "Customer Satisfaction",
    "Innovation",
    "Operational Efficiency",
    "Brand Strength",
    "Employee Satisfaction",
    "Sustainability",
]
values1 = [85, 78, 90, 95, 82, 88, 70, 76]  # Values for Amazon
values2 = [78, 65, 85, 80, 75, 80, 68, 70]  # Values for Meta
values3 = [92, 88, 72, 85, 90, 94, 80, 84]  # Values for Tesla

# Number of variables
N = len(categories)

# Compute angle for each category
angles = [n / float(N) * 2 * np.pi for n in range(N)]
values1 += values1[:1]
values2 += values2[:1]
values3 += values3[:1]
angles += angles[:1]

# Extracted variables
xticks = angles[:-1]
xtickslabel = categories
yticks = [20, 40, 60, 80, 100]
ytickslabel = ["20", "40", "60", "80", "100"]
ylim = (0, 100)
line_label1 = "Amazon"
line_label2 = "Meta"
line_label3 = "Tesla"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels
plt.xticks(xticks, xtickslabel, color="navy", size=8)
ax.tick_params(pad=15)  # Adjust the distance of the label from the axis

# Draw ylabels
ax.set_rlabel_position(30)
plt.yticks(yticks, ytickslabel, color="darkblue", size=7)
plt.ylim(ylim)

# Plot data
ax.plot(angles, values1, linewidth=2, linestyle="dashed", label=line_label1, color="gold")
ax.fill(angles, values1, color="yellow", alpha=0.25)

ax.plot(angles, values2, linewidth=2, linestyle="dashed", label=line_label2, color="silver")
ax.fill(angles, values2, color="lightgrey", alpha=0.25)

ax.plot(angles, values3, linewidth=2, linestyle="solid", label=line_label3, color="green")
ax.fill(angles, values3, color="lightgreen", alpha=0.25)

# Add legend
plt.legend(loc="upper right", bbox_to_anchor=(1.2, 1.2), ncol=3, frameon=False)

# Set the background color inside the radar chart to white
ax.set_facecolor("white")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

plt.savefig('radar_19.pdf', bbox_inches='tight')
