
import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)

# ===================
# Part 2: Data Preparation
# ===================
# Data for each method
labels = np.array(
    [
        "Cancer\nScreening",
        "Cardiovascular\nDiagnosis",
        "Infectious\nDisease Detection",
        "Neurological\nAssessment",
        "Chronic Disease\nManagement",
    ]
)
stats_method1 = np.array([55, 75, 60, 80, 73])
stats_method2 = np.array([68, 70, 86, 90, 55])
stats_method3 = np.array([73, 85, 75, 50, 85])

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
# The plot is made circular, so we need to "complete the loop" and append the start to the end.
stats_method1 = np.concatenate((stats_method1, [stats_method1[0]]))
stats_method2 = np.concatenate((stats_method2, [stats_method2[0]]))
stats_method3 = np.concatenate((stats_method3, [stats_method3[0]]))
angles += angles[:1]

# Extracted variables
label_method1 = "Method 1"
label_method2 = "Method 2"
label_method3 = "Method 3"
ylim_values = (0, 90)
xticks_values = angles[:-1]
yticks_values = [20, 40, 60, 80]
xtickslabel_values = labels
ytickslabel_values =[]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(5, 5), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels with increased padding
plt.xticks(xticks_values, xtickslabel_values)
ax.tick_params(pad=23)  # Increase the distance of the label from the axis

# Draw ylabels and set them to be dashed
ax.set_rlabel_position(0)
plt.yticks(yticks_values, ytickslabel_values, color="grey", size=7)
plt.ylim(ylim_values)

# Customizing the grid (set grid to be dashed)
ax.yaxis.grid(True, linestyle="--", color="grey", linewidth=0.5)

# Plot data
ax.plot(
    angles, stats_method1, color="red", linewidth=1, linestyle="solid", label=label_method1
)
ax.fill(angles, stats_method1, color="red", alpha=0.25)

ax.plot(
    angles, stats_method2, color="blue", linewidth=1, linestyle="dashed", label=label_method2
)
ax.fill(angles, stats_method2, color="blue", alpha=0.25)

ax.plot(
    angles,
    stats_method3,
    color="green",
    linewidth=1,
    linestyle="dotted",
    label=label_method3,
)
ax.fill(angles, stats_method3, color="green", alpha=0.25)

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.3), ncol=3, frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

# Show the plot
plt.savefig('radar_8.pdf', bbox_inches='tight')
