import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
cities = [
    "New York",
    "Los Angeles",
    "Chicago",
    "Houston",
    "Phoenix",
    "Philadelphia",
    "San Antonio",
    "San Diego",
    "Dallas",
]
weather_metrics = {
    "Temperature (°C)": [20, 25, 22, 30, 35, 18, 33, 27, 24],
    "Humidity (%)": [60, 50, 55, 70, 40, 65, 75, 45, 55],
    "Wind Speed (km/h)": [45, 60, 68, 25, 30, 62, 30, 27, 39],
    "Precipitation (mm)": [100, 50, 80, 30, 10, 120, 60, 40, 70],
    "Visibility (km)": [28, 28, 29, 37, 56, 21, 25, 21, 39],
    "UV Index": [25, 30, 20, 37, 25, 30, 35, 40, 45],
}
colors = ["blue", "orange", "green", "red", "purple", "brown"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, axes = plt.subplots(1, 6, figsize=(12, 4), sharey=True)

# Plot each category
for ax, (metric, color) in zip(axes, zip(weather_metrics.keys(), colors)):
    ax.scatter(weather_metrics[metric], cities, color=color)
    ax.set_title(metric)
    ax.axvline(x=20 if metric == "Temperature (°C)" else 50, color="black", linestyle="--", linewidth=1)

# Set common labels
fig.text(0.5, 0.04, "Value", ha="center", va="center")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout(rect=[0.03, 0.05, 1, 0.95])
plt.savefig('scatter_1.pdf', bbox_inches='tight')
