
import matplotlib.pyplot as plt
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting (education domain)
names = ["Math", "Science", "Literature", "History", "Art", "Music"]
x = [85, 90, 75, 80, 70, 95]  # Example average scores
y = [4.5, 4.0, 3.5, 3.0, 2.5, 5.0]  # Example average study hours per week
sizes = [300, 600, 900, 1200, 1500, 1800]  # Example number of students
colors = ["purple", "blue", "green", "yellow", "orange", "red"]

# Plot and legend labels
scatter_label = "Bubble Size: Number of Students"

# Axis limits
ylim_values = (2.0, 5.5)

# Axis labels
xlabel_value = "Average Scores"
ylabel_value = "Average Study Hours per Week"

# Axis ticks
xticks_values = x  # Set by FixedLocator

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(8, 6))
scatter = ax.scatter(x, y, s=sizes, c=colors, alpha=0.5, edgecolors="black", label=scatter_label)

# Add labels for each bubble
for i, txt in enumerate(names):
    ax.annotate(txt, (x[i], y[i]), ha="center", va="center", fontsize=8)

# Set the x-axis to a logarithmic scale
ax.set_xscale("log")
ax.xaxis.set_major_formatter(ticker.FuncFormatter(lambda x, _: f"{int(x):d}"))
ax.xaxis.set_major_locator(ticker.FixedLocator(x))

# Set axis labels
ax.set_xlabel(xlabel_value, fontsize=10)
ax.set_ylabel(ylabel_value, fontsize=10)
ax.set_ylim(ylim_values)

# Add grid
ax.grid(True, which="both", linestyle="--", linewidth=0.5)

# Set background color to white
fig.patch.set_facecolor("white")
ax.set_facecolor("white")

# Add legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig('scatter_11.pdf', bbox_inches='tight')
