import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
conditions = [
    "Hypertension",
    "Diabetes",
    "Asthma",
    "Cancer",
    "Heart Disease",
    "Stroke",
    "Obesity",
    "Arthritis",
]
prevalence_rate = [0.45, 0.32, 0.10, 0.08, 0.12, 0.04, 0.36, 0.25]
treatment_success_rate = [0.70, 0.65, 0.80, 0.55, 0.60, 0.50, 0.55, 0.60]
xlabel = "Medical Conditions"
ylabel = "Rate"
labels = ["Prevalence Rate", "Treatment Success Rate"]
title = "Prevalence and Treatment Success Rates for Various Medical Conditions"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(6, 3))

# Plotting the data without error bars
plt.scatter(conditions, prevalence_rate, color="blue", label=labels[0])
plt.scatter(conditions, treatment_success_rate, color="red", label=labels[1])

# Adding labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding grid
plt.grid(True, linestyle="--", linewidth=0.5)

# Rotate x-axis labels for better readability
plt.xticks(rotation=90)
plt.ylim(0, 1.5)
# Adjusting legend placement to match the reference picture
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to match the reference picture
plt.tight_layout()
plt.savefig('scatter_14.pdf', bbox_inches='tight')
