import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plots
renewables = ["Solar", "Wind", "Hydro", "Geothermal", "Biomass", "Tidal", "Wave"]
x1 = [150, 100, 50, 70, 80, 120, 110]
y1 = [85, 88, 90, 83, 87, 85, 89]
colors1 = ["yellow", "blue", "cyan", "orange", "green", "purple", "magenta"]

x2 = [5e3, 3.5e3, 1.5e3, 2e3, 2.2e3, 4.5e3, 4e3]
y2 = [85, 88, 90, 83, 87, 85, 89]
colors2 = ["yellow", "blue", "cyan", "orange", "green", "purple", "magenta"]

titles = ["Renewable Energy Sources (Efficiency vs Installation Cost)", "Renewable Energy Sources (Efficiency vs Energy Output)"]
xlabels = ["Installation Cost ($ thousands)", "Energy Output (MWh)"]
ylabels = ["Efficiency (%)", "Efficiency (%)"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 4))

# First subplot
ax1.scatter(x1, y1, c=colors1)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.invert_xaxis()  # Invert x-axis
for i, txt in enumerate(renewables):
    ax1.annotate(txt, (x1[i], y1[i]), xytext=(-10, 5), textcoords="offset points")
ax1.set_xlim([160, 40])
ax1.set_ylim([80, 95])

# Second subplot
ax2.scatter(x2, y2, c=colors2)
ax2.set_title(titles[1])
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.ticklabel_format(style="sci", axis="x", scilimits=(0, 0))  # Use scientific notation
for i, txt in enumerate(renewables):
    ax2.annotate(txt, (x2[i], y2[i]), xytext=(-15, 5), textcoords="offset points")
ax2.set_xlim([6e3, 1e3])
ax2.set_ylim([80, 95])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('scatter_15.pdf', bbox_inches='tight')
