import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Day one, the age and blood pressure of 13 patients:
ages_day1 = np.array([30, 45, 50, 60, 25, 70, 30, 55, 40, 65, 75, 55, 35])
bp_day1 = np.array([120, 135, 130, 145, 125, 140, 128, 130, 135, 138, 145, 132, 130])

# Day two, the age and blood pressure of 15 patients:
ages_day2 = np.array([25, 30, 55, 20, 70, 50, 65, 60, 40, 35, 75, 45, 55, 68, 62])
bp_day2 = np.array([122, 128, 133, 130, 140, 135, 142, 138, 134, 136, 145, 138, 137, 139, 141])

legend_labels = ["Monday", "Tuesday"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(6, 6))
plt.scatter(ages_day1, bp_day1)
plt.scatter(ages_day2, bp_day2)
plt.grid(True)
plt.legend(legend_labels)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('scatter_18.pdf', bbox_inches='tight')
