import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
x_sc = [70, 74, 78]
y_sc = [27.5, 32.5, 40]
sizes_sc = [100, 200, 300]

x_ft = [71, 75, 77]
y_ft = [28, 36, 38]
sizes_ft = [100, 200, 300]

x_vl = [73, 76, 78]
y_vl = [29, 34, 42.5]
sizes_vl = [100, 200, 300]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(
    figsize=(4, 8)
)  # Adjust the size to match the original image's dimensions

# Scatter points
sc_scatter = ax.scatter(x_sc, y_sc, s=sizes_sc, alpha=0.8, color="lightblue")
ft_scatter = ax.scatter(x_ft, y_ft, s=sizes_ft, alpha=0.8, color="salmon")
vl_scatter = ax.scatter(x_vl, y_vl, s=sizes_vl, alpha=0.8, color="grey")

# Connect points with dashed lines
ax.plot(x_sc, y_sc, linestyle="--", color="lightblue", alpha=0.8)
ax.plot(x_ft, y_ft, linestyle="--", color="salmon", alpha=0.8)
ax.plot(x_vl, y_vl, linestyle="--", color="grey", alpha=0.8)

# Legend
legend_labels = ["ViTPose (sc)", "ViTPose (ft)", "VLPose"]
legend = ax.legend(
    [sc_scatter, ft_scatter, vl_scatter],
    legend_labels,
    title="Models",
    loc="upper left",
)
legend.get_frame().set_alpha(1)  # Make legend background opaque

# Axes labels
ax.set_xlabel("Average Precision on MSCOCO (%)")
ax.set_ylabel("Average Precision on HumanArt (%)")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig('scatter_2.pdf', bbox_inches='tight')
