import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
business_models = [
    "Freemium",
    "Subscription",
    "E-commerce",
    "Marketplace",
    "Ad-Based",
    "Franchise",
    "Retail",
    "Consulting",
    "Manufacturing",
]
financial_metrics = {
    "Revenue Growth": [10, 8, 12, 7, 5, 9, 6, 11, 13],
    "Profit Margin": [20, 15, 18, 12, 25, 10, 14, 22, 16],
    "Customer Acquisition Cost": [50, 45, 40, 60, 55, 35, 30, 65, 70],
    "Customer Lifetime Value": [200, 180, 220, 170, 210, 160, 150, 230, 240],
    "Market Share": [8, 7, 9, 6, 10, 5, 4, 11, 12],
    "Churn Rate": [5, 6, 4, 7, 3, 8, 9, 2, 1],
}
metrics_group1 = ["Revenue Growth", "Profit Margin"]
colors1 = ["blue", "orange"]
metrics_group2 = ["Customer Acquisition Cost", "Customer Lifetime Value"]
colors2 = ["green", "red"]
titles = ["Growth and Profitability", "Customer Metrics"]
xlabel = "Value"
ylabel = "Business Models"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6), sharey=True)

# Plotting for ax1 - first two metrics
for metric, color in zip(metrics_group1, colors1):
    ax1.scatter(financial_metrics[metric], business_models, color=color, label=metric)
ax1.set_title(titles[0])
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.legend()

# Plotting for ax2 - next two metrics
for metric, color in zip(metrics_group2, colors2):
    ax2.scatter(financial_metrics[metric], business_models, color=color, label=metric)
ax2.set_title(titles[1])
ax2.set_xlabel(xlabel)
ax2.legend()

# Common settings
for ax in [ax1, ax2]:
    ax.set_yticks(range(len(business_models)))
    ax.set_yticklabels(business_models)
    ax.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig('scatter_22.pdf', bbox_inches='tight')
